/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOServerCraftingTransferHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.recipe.MekanismRecipeType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PacketQIOFillCraftingWindow
implements IMekanismPacket<PlayPayloadContext> {
    public static final ResourceLocation ID = Mekanism.rl("fill_qio");
    private final Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources;
    private final ResourceLocation recipeID;
    private final boolean rejectToInventory;
    private final boolean transferMultiple;

    public PacketQIOFillCraftingWindow(ResourceLocation recipeID, boolean transferMultiple, boolean rejectToInventory, Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources) {
        this.recipeID = recipeID;
        this.sources = sources;
        this.transferMultiple = transferMultiple;
        this.rejectToInventory = rejectToInventory;
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu;
        Player player = context.player().orElse(null);
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof QIOItemViewerContainer) {
            QIOItemViewerContainer container = (QIOItemViewerContainer)abstractContainerMenu;
            byte selectedCraftingGrid = container.getSelectedCraftingGrid(player.getUUID());
            if (selectedCraftingGrid == -1) {
                Mekanism.logger.warn("Received transfer request from: {}, but they do not currently have a crafting window open.", (Object)player);
            } else {
                Optional<RecipeHolder<?>> optionalRecipe = MekanismRecipeType.byKey(player.level(), this.recipeID);
                if (optionalRecipe.isPresent()) {
                    Recipe recipe = optionalRecipe.get().value();
                    if (recipe instanceof CraftingRecipe) {
                        CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                        QIOServerCraftingTransferHandler.tryTransfer(container, selectedCraftingGrid, this.rejectToInventory, player, this.recipeID, craftingRecipe, this.sources);
                    } else {
                        Mekanism.logger.warn("Received transfer request from: {}, but the type ({}) of the specified recipe was not a crafting recipe.", (Object)player, recipe.getClass());
                    }
                } else {
                    Mekanism.logger.warn("Received transfer request from: {}, but could not find specified recipe.", (Object)player);
                }
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.recipeID);
        buffer.writeBoolean(this.transferMultiple);
        buffer.writeBoolean(this.rejectToInventory);
        buffer.writeByte((byte)this.sources.size());
        for (Byte2ObjectMap.Entry entry : this.sources.byte2ObjectEntrySet()) {
            buffer.writeByte(entry.getByteKey());
            List slotSources = (List)entry.getValue();
            if (this.transferMultiple) {
                buffer.writeVarInt(slotSources.size());
            }
            for (QIOCraftingTransferHelper.SingularHashedItemSource source : slotSources) {
                byte sourceSlot = source.getSlot();
                buffer.writeByte(sourceSlot);
                if (this.transferMultiple) {
                    buffer.writeVarInt(source.getUsed());
                }
                if (sourceSlot != -1) continue;
                UUID qioSource = source.getQioSource();
                if (qioSource == null) {
                    throw new IllegalStateException("Invalid QIO crafting window transfer source.");
                }
                buffer.writeUUID(qioSource);
            }
        }
    }

    public static PacketQIOFillCraftingWindow decode(FriendlyByteBuf buffer) {
        ResourceLocation recipeID = buffer.readResourceLocation();
        boolean transferMultiple = buffer.readBoolean();
        boolean rejectToInventory = buffer.readBoolean();
        byte slotCount = buffer.readByte();
        Byte2ObjectArrayMap sources = new Byte2ObjectArrayMap((int)slotCount);
        for (byte slot = 0; slot < slotCount; slot = (byte)(slot + 1)) {
            byte targetSlot = buffer.readByte();
            int subSourceCount = transferMultiple ? buffer.readVarInt() : 1;
            ArrayList<QIOCraftingTransferHelper.SingularHashedItemSource> slotSources = new ArrayList<QIOCraftingTransferHelper.SingularHashedItemSource>(subSourceCount);
            sources.put(targetSlot, slotSources);
            for (int i = 0; i < subSourceCount; ++i) {
                int count;
                byte sourceSlot = buffer.readByte();
                int n = count = transferMultiple ? buffer.readVarInt() : 1;
                if (sourceSlot == -1) {
                    slotSources.add(new QIOCraftingTransferHelper.SingularHashedItemSource(buffer.readUUID(), count));
                    continue;
                }
                slotSources.add(new QIOCraftingTransferHelper.SingularHashedItemSource(sourceSlot, count));
            }
        }
        return new PacketQIOFillCraftingWindow(recipeID, transferMultiple, rejectToInventory, (Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)sources);
    }
}

