/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketQIOItemViewerSlotPlace(int count) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("qio_place");

    public PacketQIOItemViewerSlotPlace(FriendlyByteBuf buffer) {
        this(buffer.readVarInt());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        ItemStack curStack;
        QIOFrequency freq;
        QIOItemViewerContainer container = PacketUtils.container((IPayloadContext)context, QIOItemViewerContainer.class);
        if (container != null && (freq = container.getFrequency()) != null && !(curStack = container.getCarried()).isEmpty() && this.count > 0) {
            ItemStack toAdd = this.count < curStack.getCount() ? curStack.copyWithCount(this.count) : curStack;
            ItemStack rejects = freq.addItem(toAdd);
            int placed = toAdd.getCount() - rejects.getCount();
            if (placed > 0) {
                curStack.shrink(placed);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.count);
    }
}

