/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketQIOItemViewerSlotShiftTake(UUID typeUUID) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("qio_shift_take");

    public PacketQIOItemViewerSlotShiftTake(FriendlyByteBuf buffer) {
        this(buffer.readUUID());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        HashedItem itemType;
        QIOItemViewerContainer container;
        QIOFrequency freq;
        AbstractContainerMenu abstractContainerMenu;
        Player player = context.player().orElse(null);
        if (player != null && (abstractContainerMenu = player.containerMenu) instanceof QIOItemViewerContainer && (freq = (container = (QIOItemViewerContainer)abstractContainerMenu).getFrequency()) != null && (itemType = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(this.typeUUID)) != null) {
            ItemStack remainder;
            ItemStack maxExtract = itemType.createStack(itemType.getMaxStackSize());
            ItemStack simulatedExcess = container.simulateInsertIntoPlayerInventory(player.getUUID(), maxExtract);
            ItemStack extracted = freq.removeByType(itemType, maxExtract.getCount() - simulatedExcess.getCount());
            if (!(extracted.isEmpty() || (remainder = container.insertIntoPlayerInventory(player.getUUID(), extracted)).isEmpty() || (remainder = freq.addItem(remainder)).isEmpty())) {
                Mekanism.logger.error("QIO shift-click transfer resulted in lost items ({}). This shouldn't happen!", (Object)remainder);
                player.drop(remainder, false);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeUUID(this.typeUUID);
    }
}

