/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.qio;

import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.content.qio.QIOGlobalItemLookup;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.lib.inventory.HashedItem;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.InventoryUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketQIOItemViewerSlotTake(UUID typeUUID, int count) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("qio_take");

    public PacketQIOItemViewerSlotTake(FriendlyByteBuf buffer) {
        this(buffer.readUUID(), buffer.readVarInt());
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        HashedItem itemType;
        QIOFrequency freq;
        QIOItemViewerContainer container = PacketUtils.container((IPayloadContext)context, QIOItemViewerContainer.class);
        if (container != null && (freq = container.getFrequency()) != null && (itemType = QIOGlobalItemLookup.INSTANCE.getTypeByUUID(this.typeUUID)) != null) {
            ItemStack extracted;
            ItemStack curStack = container.getCarried();
            int toRemove = Math.min(this.count, itemType.getMaxStackSize() - curStack.getCount());
            if (toRemove > 0 && InventoryUtils.areItemsStackable(curStack, itemType.getInternalStack()) && !(extracted = freq.removeByType(itemType, toRemove)).isEmpty()) {
                if (curStack.isEmpty()) {
                    container.setCarried(extracted);
                } else {
                    curStack.grow(extracted.getCount());
                }
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeUUID(this.typeUUID);
        buffer.writeVarInt(this.count);
    }
}

