/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.robit;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mekanism.api.robit.RobitSkin;
import mekanism.api.security.IEntitySecurityUtils;
import mekanism.api.text.TextComponentUtil;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.entity.RobitPrideSkinData;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.registries.MekanismRobitSkins;
import net.minecraft.Util;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketRobitName(int entityId, String name) implements IMekanismPacket<PlayPayloadContext>
{
    public static final int MAX_NAME_LENGTH = 50;
    public static final ResourceLocation ID = Mekanism.rl("robit_name");
    private static final Map<String, List<ResourceKey<RobitSkin>>> EASTER_EGGS = Map.of("sara", PacketRobitName.getPrideSkins(RobitPrideSkinData.TRANS, RobitPrideSkinData.LESBIAN));

    public PacketRobitName(FriendlyByteBuf buffer) {
        this(buffer.readVarInt(), buffer.readUtf(50));
    }

    public PacketRobitName(EntityRobit robit, String name) {
        this(robit.getId(), name);
    }

    public PacketRobitName {
        name = name.trim();
    }

    private static List<ResourceKey<RobitSkin>> getPrideSkins(RobitPrideSkinData ... prideSkinData) {
        return Stream.of(prideSkinData).map(MekanismRobitSkins.PRIDE_SKINS::get).toList();
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        EntityRobit robit;
        Entity entity;
        if (!PacketRobitName.hasContent(this.name)) {
            return;
        }
        Player player = context.player().orElse(null);
        if (player != null && (entity = player.level().getEntity(this.entityId)) instanceof EntityRobit && IEntitySecurityUtils.INSTANCE.canAccess(player, robit = (EntityRobit)entity)) {
            Optional randomSkin;
            robit.setCustomName((Component)TextComponentUtil.getString(this.name));
            if (robit.getSkin() == MekanismRobitSkins.BASE && (randomSkin = Util.getRandomSafe(EASTER_EGGS.getOrDefault(this.name.toLowerCase(Locale.ROOT), Collections.emptyList()), (RandomSource)robit.level().random)).isPresent()) {
                robit.setSkin((ResourceKey<RobitSkin>)((ResourceKey)randomSkin.get()), null);
            }
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entityId);
        buffer.writeUtf(this.name, 50);
    }

    public static boolean hasContent(String text) {
        if (!text.isEmpty()) {
            boolean wasColorSymbol = false;
            for (char c : text.toCharArray()) {
                if (c == '\u00a7') {
                    wasColorSymbol = true;
                    continue;
                }
                if (!wasColorSymbol) {
                    return true;
                }
                wasColorSymbol = false;
            }
        }
        return false;
    }
}

