/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server.robit;

import mekanism.api.MekanismAPI;
import mekanism.api.robit.RobitSkin;
import mekanism.common.Mekanism;
import mekanism.common.entity.EntityRobit;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketRobitSkin(int entityId, ResourceKey<RobitSkin> skin) implements IMekanismPacket<PlayPayloadContext>
{
    public static final ResourceLocation ID = Mekanism.rl("robit_skin");

    public PacketRobitSkin(FriendlyByteBuf buffer) {
        this(buffer.readVarInt(), (ResourceKey<RobitSkin>)buffer.readResourceKey(MekanismAPI.ROBIT_SKIN_REGISTRY_NAME));
    }

    public PacketRobitSkin(EntityRobit robit, @NotNull ResourceKey<RobitSkin> skin) {
        this(robit.getId(), skin);
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }

    @Override
    public void handle(PlayPayloadContext context) {
        Entity entity;
        Player player = context.player().orElse(null);
        if (player != null && (entity = player.level().getEntity(this.entityId)) instanceof EntityRobit) {
            EntityRobit robit = (EntityRobit)entity;
            robit.setSkin(this.skin, player);
        }
    }

    public void write(@NotNull FriendlyByteBuf buffer) {
        buffer.writeVarInt(this.entityId);
        buffer.writeResourceKey(this.skin);
    }
}

