/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import mekanism.common.registries.MekanismParticleTypes;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public record LaserParticleData(Direction direction, double distance, float energyScale) implements ParticleOptions
{
    public static final ParticleOptions.Deserializer<LaserParticleData> DESERIALIZER = new ParticleOptions.Deserializer<LaserParticleData>(){

        @NotNull
        public LaserParticleData fromCommand(@NotNull ParticleType<LaserParticleData> type, @NotNull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            Direction direction = Direction.from3DDataValue((int)reader.readInt());
            reader.expect(' ');
            double distance = reader.readDouble();
            reader.expect(' ');
            float energyScale = reader.readFloat();
            return new LaserParticleData(direction, distance, energyScale);
        }

        @NotNull
        public LaserParticleData fromNetwork(@NotNull ParticleType<LaserParticleData> type, FriendlyByteBuf buf) {
            return new LaserParticleData((Direction)buf.readEnum(Direction.class), buf.readDouble(), buf.readFloat());
        }
    };
    public static final Codec<LaserParticleData> CODEC = RecordCodecBuilder.create(val -> val.group((App)Direction.CODEC.fieldOf("direction").forGetter(data -> data.direction), (App)Codec.DOUBLE.fieldOf("distance").forGetter(data -> data.distance), (App)Codec.FLOAT.fieldOf("energyScale").forGetter(data -> Float.valueOf(data.energyScale))).apply((Applicative)val, LaserParticleData::new));

    @NotNull
    public ParticleType<?> getType() {
        return (ParticleType)MekanismParticleTypes.LASER.get();
    }

    public void writeToNetwork(@NotNull FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.direction);
        buffer.writeDouble(this.distance);
        buffer.writeFloat(this.energyScale);
    }

    @NotNull
    public String writeToString() {
        return String.format(Locale.ROOT, "%s %d %.2f %.2f", RegistryUtils.getName(this.getType()), this.direction.ordinal(), this.distance, Float.valueOf(this.energyScale));
    }
}

