/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import mekanism.api.Action;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

@NothingNullByDefault
public class BinExtractRecipe
extends BinRecipe {
    public BinExtractRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack binStack = this.findBinStack(inv);
        if (binStack.isEmpty()) {
            return false;
        }
        return !BinExtractRecipe.convertToSlot(binStack).isEmpty();
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack binStack = this.findBinStack(inv);
        if (binStack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return BinExtractRecipe.convertToSlot(binStack).getBottomStack();
    }

    private ItemStack findBinStack(CraftingContainer inv) {
        ItemStack binStack = ItemStack.EMPTY;
        int slots = inv.getContainerSize();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ItemBlockBin) {
                if (!binStack.isEmpty() || stackInSlot.getCount() > 1) {
                    return ItemStack.EMPTY;
                }
                binStack = stackInSlot;
                continue;
            }
            return ItemStack.EMPTY;
        }
        return binStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        int slots = inv.getContainerSize();
        NonNullList remaining = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (!(stackInSlot.getItem() instanceof ItemBlockBin)) continue;
            ItemStack binStack = stackInSlot.copy();
            BinInventorySlot slot = BinExtractRecipe.convertToSlot(binStack);
            ItemStack bottomStack = slot.getBottomStack();
            if (bottomStack.isEmpty()) break;
            MekanismUtils.logMismatchedStackSize(slot.shrinkStack(bottomStack.getCount(), Action.EXECUTE), bottomStack.getCount());
            remaining.set(i, (Object)binStack);
            break;
        }
        return remaining;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 1;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializersInternal.BIN_EXTRACT.get();
    }
}

