/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.bin;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.recipe.bin.BinRecipe;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@NothingNullByDefault
public class BinInsertRecipe
extends BinRecipe {
    public BinInsertRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingContainer inv, Level world) {
        ItemStack binStack = ItemStack.EMPTY;
        ItemStack foundType = ItemStack.EMPTY;
        int slots = inv.getContainerSize();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ItemBlockBin) {
                if (!binStack.isEmpty() || stackInSlot.getCount() > 1) {
                    return false;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.isEmpty()) {
                foundType = stackInSlot;
                continue;
            }
            if (ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) continue;
            return false;
        }
        if (binStack.isEmpty() || foundType.isEmpty()) {
            return false;
        }
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        ItemStack remaining = slot.insertItem(foundType, Action.SIMULATE, AutomationType.MANUAL);
        return !ItemStack.matches((ItemStack)remaining, (ItemStack)foundType);
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack binStack = ItemStack.EMPTY;
        ItemStack foundType = ItemStack.EMPTY;
        ArrayList<ItemStack> foundItems = new ArrayList<ItemStack>();
        int slots = inv.getContainerSize();
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ItemBlockBin) {
                if (!binStack.isEmpty() || stackInSlot.getCount() > 1) {
                    return ItemStack.EMPTY;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.isEmpty()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return ItemStack.EMPTY;
            }
            foundItems.add(stackInSlot);
        }
        if (binStack.isEmpty() || foundType.isEmpty()) {
            return ItemStack.EMPTY;
        }
        binStack = binStack.copy();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        boolean hasInserted = false;
        for (ItemStack stack : foundItems) {
            ItemStack toInsert = stack.copyWithCount(1);
            ItemStack remainder = slot.insertItem(toInsert, Action.EXECUTE, AutomationType.MANUAL);
            if (remainder.isEmpty()) {
                hasInserted = true;
                continue;
            }
            if (hasInserted) {
                return binStack;
            }
            return ItemStack.EMPTY;
        }
        binStack.setData(MekanismAttachmentTypes.FROM_RECIPE, (Object)true);
        return binStack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        int slots = inv.getContainerSize();
        NonNullList remainingItems = NonNullList.withSize((int)slots, (Object)ItemStack.EMPTY);
        ItemStack binStack = ItemStack.EMPTY;
        ItemStack foundType = ItemStack.EMPTY;
        Int2ObjectArrayMap foundSlots = new Int2ObjectArrayMap(slots);
        for (int i = 0; i < slots; ++i) {
            ItemStack stackInSlot = inv.getItem(i);
            if (stackInSlot.isEmpty()) continue;
            if (stackInSlot.getItem() instanceof ItemBlockBin) {
                if (!binStack.isEmpty()) {
                    return remainingItems;
                }
                binStack = stackInSlot;
                continue;
            }
            if (foundType.isEmpty()) {
                foundType = stackInSlot;
            } else if (!ItemHandlerHelper.canItemStacksStack((ItemStack)foundType, (ItemStack)stackInSlot)) {
                return remainingItems;
            }
            foundSlots.put(i, (Object)stackInSlot);
        }
        if (binStack.isEmpty() || foundType.isEmpty()) {
            return remainingItems;
        }
        binStack = binStack.copy();
        BinInventorySlot slot = BinInsertRecipe.convertToSlot(binStack);
        for (Int2ObjectMap.Entry entry : foundSlots.int2ObjectEntrySet()) {
            ItemStack slotItem = (ItemStack)entry.getValue();
            ItemStack remaining = slot.insertItem(slotItem.copyWithCount(1), Action.EXECUTE, AutomationType.MANUAL);
            if (remaining.isEmpty()) continue;
            remainingItems.set(entry.getIntKey(), (Object)remaining);
        }
        return remainingItems;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializersInternal.BIN_INSERT.get();
    }

    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        BinInventorySlot slot;
        ItemStack storedStack;
        Boolean fromRecipe;
        ItemStack result = event.getCrafting();
        if (!result.isEmpty() && result.getItem() instanceof ItemBlockBin && (fromRecipe = (Boolean)result.removeData(MekanismAttachmentTypes.FROM_RECIPE)) != null && fromRecipe.booleanValue() && !(storedStack = (slot = BinInsertRecipe.convertToSlot(result)).getStack()).isEmpty()) {
            Container craftingMatrix = event.getInventory();
            int slots = craftingMatrix.getContainerSize();
            for (int i = 0; i < slots; ++i) {
                ItemStack stack = craftingMatrix.getItem(i);
                if (stack.getCount() <= 1 || !ItemHandlerHelper.canItemStacksStack((ItemStack)storedStack, (ItemStack)stack)) continue;
                ItemStack toInsert = stack.copyWithCount(stack.getCount() - 1);
                ItemStack remaining = slot.insertItem(toInsert, Action.EXECUTE, AutomationType.MANUAL);
                if (remaining.isEmpty()) {
                    craftingMatrix.setItem(i, stack.copyWithCount(1));
                    continue;
                }
                if (remaining.getCount() >= toInsert.getCount()) continue;
                craftingMatrix.setItem(i, stack.copyWithCount(remaining.getCount() + 1));
            }
        }
    }
}

