/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.common.recipe.condition.MekanismRecipeConditions;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.apache.maven.artifact.versioning.ComparableVersion;

public record ModVersionLoadedCondition(String modid, String minVersion) implements ICondition
{
    public boolean test(ICondition.IContext context) {
        Optional containerById = ModList.get().getModContainerById(this.modid);
        if (containerById.isEmpty()) {
            return false;
        }
        ModContainer modContainer = (ModContainer)containerById.get();
        return new ComparableVersion(this.minVersion).compareTo(new ComparableVersion(modContainer.getModInfo().getVersion().toString())) <= 0;
    }

    public Codec<? extends ICondition> codec() {
        return (Codec)MekanismRecipeConditions.MOD_VERSION_LOADED.get();
    }

    public static Codec<ModVersionLoadedCondition> makeCodec() {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("modid").forGetter(ModVersionLoadedCondition::modid), (App)Codec.STRING.fieldOf("minVersion").forGetter(ModVersionLoadedCondition::minVersion)).apply((Applicative)instance, ModVersionLoadedCondition::new));
    }
}

