/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IChemicalStackIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.ingredient.chemical.MultiChemicalStackIngredient;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

@NothingNullByDefault
public class ChemicalIngredientDeserializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>> {
    public static final ChemicalIngredientDeserializer<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> GAS = new ChemicalIngredientDeserializer<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(MekanismAPI.GAS_REGISTRY_NAME, GasStack::readFromPacket, IngredientCreatorAccess.gas(), MultiChemicalStackIngredient.MultiGasStackIngredient::new, ChemicalStackIngredient.GasStackIngredient[]::new);
    public static final ChemicalIngredientDeserializer<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> INFUSION = new ChemicalIngredientDeserializer<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, InfusionStack::readFromPacket, IngredientCreatorAccess.infusion(), MultiChemicalStackIngredient.MultiInfusionStackIngredient::new, ChemicalStackIngredient.InfusionStackIngredient[]::new);
    public static final ChemicalIngredientDeserializer<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> PIGMENT = new ChemicalIngredientDeserializer<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>(MekanismAPI.PIGMENT_REGISTRY_NAME, PigmentStack::readFromPacket, IngredientCreatorAccess.pigment(), MultiChemicalStackIngredient.MultiPigmentStackIngredient::new, ChemicalStackIngredient.PigmentStackIngredient[]::new);
    public static final ChemicalIngredientDeserializer<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient> SLURRY = new ChemicalIngredientDeserializer<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient>(MekanismAPI.SLURRY_REGISTRY_NAME, SlurryStack::readFromPacket, IngredientCreatorAccess.slurry(), MultiChemicalStackIngredient.MultiSlurryStackIngredient::new, ChemicalStackIngredient.SlurryStackIngredient[]::new);
    private final ResourceKey<? extends Registry<CHEMICAL>> registry;
    private final FriendlyByteBuf.Reader<STACK> fromPacket;
    private final IChemicalStackIngredientCreator<CHEMICAL, STACK, INGREDIENT> ingredientCreator;
    private final IntFunction<INGREDIENT[]> arrayCreator;
    private final Function<INGREDIENT[], INGREDIENT> multiCreator;

    private ChemicalIngredientDeserializer(ResourceKey<? extends Registry<CHEMICAL>> registry, FriendlyByteBuf.Reader<STACK> fromPacket, IChemicalStackIngredientCreator<CHEMICAL, STACK, INGREDIENT> ingredientCreator, Function<INGREDIENT[], INGREDIENT> multiCreator, IntFunction<INGREDIENT[]> arrayCreator) {
        this.fromPacket = fromPacket;
        this.registry = registry;
        this.ingredientCreator = ingredientCreator;
        this.arrayCreator = arrayCreator;
        this.multiCreator = multiCreator;
    }

    public final INGREDIENT read(FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "ChemicalStackIngredients cannot be read from a null packet buffer.");
        return switch ((IngredientType)buffer.readEnum(IngredientType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientType.SINGLE -> this.ingredientCreator.from((ChemicalStack)this.fromPacket.apply((Object)buffer));
            case IngredientType.TAGGED -> this.ingredientCreator.from(TagKey.create(this.registry, (ResourceLocation)buffer.readResourceLocation()), buffer.readVarLong());
            case IngredientType.MULTI -> this.createMulti((ChemicalStackIngredient[])buffer.readArray(this.arrayCreator, this::read));
        };
    }

    @SafeVarargs
    public final INGREDIENT createMulti(INGREDIENT ... ingredients) {
        Objects.requireNonNull(ingredients, "Cannot create a multi ingredient out of a null array.");
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create a multi ingredient out of no ingredients.");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<INGREDIENT> cleanedIngredients = new ArrayList<INGREDIENT>();
        for (INGREDIENT ingredient : ingredients) {
            if (ingredient instanceof MultiChemicalStackIngredient) {
                cleanedIngredients.addAll(((MultiChemicalStackIngredient)ingredient).getIngredients());
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return (INGREDIENT)((ChemicalStackIngredient)this.multiCreator.apply(cleanedIngredients.toArray((ChemicalStackIngredient[])this.arrayCreator.apply(0))));
    }

    public Codec<INGREDIENT> codec() {
        return this.ingredientCreator.codec();
    }

    static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }
}

