/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.IMultiIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public abstract class MultiChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>>
implements ChemicalStackIngredient<CHEMICAL, STACK>,
IMultiIngredient<STACK, INGREDIENT> {
    private final INGREDIENT[] ingredients;

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, MULTI extends MultiChemicalStackIngredient<CHEMICAL, STACK, INGREDIENT>> Codec<MULTI> makeCodec(Codec<INGREDIENT> singleJoinedCodec, Function<List<INGREDIENT>, MULTI> multiConstructor) {
        return ExtraCodecs.nonEmptyList((Codec)singleJoinedCodec.listOf()).xmap(multiConstructor, MultiChemicalStackIngredient::getIngredients);
    }

    @SafeVarargs
    protected MultiChemicalStackIngredient(INGREDIENT ... ingredients) {
        this.ingredients = ingredients;
    }

    protected abstract ChemicalIngredientInfo<CHEMICAL, STACK> getIngredientInfo();

    @Override
    public final List<INGREDIENT> getIngredients() {
        return List.of(this.ingredients);
    }

    @Override
    public boolean test(@NotNull STACK stack) {
        for (INGREDIENT ingredient : this.ingredients) {
            if (!ingredient.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testType(@NotNull STACK stack) {
        for (INGREDIENT ingredient : this.ingredients) {
            if (!ingredient.testType(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean testType(@NotNull CHEMICAL chemical) {
        for (INGREDIENT ingredient : this.ingredients) {
            if (!ingredient.testType(chemical)) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public STACK getMatchingInstance(@NotNull STACK stack) {
        for (INGREDIENT ingredient : this.ingredients) {
            ChemicalStack matchingInstance = (ChemicalStack)ingredient.getMatchingInstance(stack);
            if (matchingInstance.isEmpty()) continue;
            return (STACK)matchingInstance;
        }
        return this.getIngredientInfo().getEmptyStack();
    }

    @Override
    public long getNeededAmount(@NotNull STACK stack) {
        for (INGREDIENT ingredient : this.ingredients) {
            long amount = ingredient.getNeededAmount(stack);
            if (amount <= 0L) continue;
            return amount;
        }
        return 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        for (INGREDIENT ingredient : this.ingredients) {
            if (ingredient.hasNoMatchingInstances()) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull STACK> getRepresentations() {
        ArrayList<@NotNull TYPE> representations = new ArrayList();
        for (INGREDIENT ingredient : this.ingredients) {
            representations.addAll(ingredient.getRepresentations());
        }
        return representations;
    }

    @Override
    public boolean forEachIngredient(Predicate<INGREDIENT> checker) {
        boolean result = false;
        for (INGREDIENT ingredient : this.ingredients) {
            result |= checker.test(ingredient);
        }
        return result;
    }

    @Override
    public <DATA> boolean forEachIngredient(DATA data, BiPredicate<DATA, INGREDIENT> checker) {
        boolean result = false;
        for (INGREDIENT ingredient : this.ingredients) {
            result |= checker.test(data, ingredient);
        }
        return result;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)ChemicalIngredientDeserializer.IngredientType.MULTI);
        buffer.writeArray((Object[])this.ingredients, (buf, ingredient) -> ingredient.write((FriendlyByteBuf)buf));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Arrays.equals(this.ingredients, ((MultiChemicalStackIngredient)o).ingredients);
    }

    public int hashCode() {
        return Arrays.hashCode(this.ingredients);
    }

    public static class MultiSlurryStackIngredient
    extends MultiChemicalStackIngredient<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient>
    implements ChemicalStackIngredient.SlurryStackIngredient {
        MultiSlurryStackIngredient(ChemicalStackIngredient.SlurryStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @ApiStatus.Internal
        public MultiSlurryStackIngredient(List<ChemicalStackIngredient.SlurryStackIngredient> ingredients) {
            this(ingredients.toArray(new ChemicalStackIngredient.SlurryStackIngredient[0]));
        }

        @Override
        protected ChemicalIngredientInfo<Slurry, SlurryStack> getIngredientInfo() {
            return ChemicalIngredientInfo.SLURRY;
        }
    }

    public static class MultiPigmentStackIngredient
    extends MultiChemicalStackIngredient<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>
    implements ChemicalStackIngredient.PigmentStackIngredient {
        MultiPigmentStackIngredient(ChemicalStackIngredient.PigmentStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @ApiStatus.Internal
        public MultiPigmentStackIngredient(List<ChemicalStackIngredient.PigmentStackIngredient> ingredients) {
            this(ingredients.toArray(new ChemicalStackIngredient.PigmentStackIngredient[0]));
        }

        @Override
        protected ChemicalIngredientInfo<Pigment, PigmentStack> getIngredientInfo() {
            return ChemicalIngredientInfo.PIGMENT;
        }
    }

    public static class MultiInfusionStackIngredient
    extends MultiChemicalStackIngredient<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>
    implements ChemicalStackIngredient.InfusionStackIngredient {
        MultiInfusionStackIngredient(ChemicalStackIngredient.InfusionStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @ApiStatus.Internal
        public MultiInfusionStackIngredient(List<ChemicalStackIngredient.InfusionStackIngredient> ingredients) {
            this(ingredients.toArray(new ChemicalStackIngredient.InfusionStackIngredient[0]));
        }

        @Override
        protected ChemicalIngredientInfo<InfuseType, InfusionStack> getIngredientInfo() {
            return ChemicalIngredientInfo.INFUSION;
        }
    }

    public static class MultiGasStackIngredient
    extends MultiChemicalStackIngredient<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>
    implements ChemicalStackIngredient.GasStackIngredient {
        MultiGasStackIngredient(ChemicalStackIngredient.GasStackIngredient ... ingredients) {
            super((ChemicalStackIngredient[])ingredients);
        }

        @ApiStatus.Internal
        public MultiGasStackIngredient(List<ChemicalStackIngredient.GasStackIngredient> ingredients) {
            this(ingredients.toArray(new ChemicalStackIngredient.GasStackIngredient[0]));
        }

        @Override
        protected ChemicalIngredientInfo<Gas, GasStack> getIngredientInfo() {
            return ChemicalIngredientInfo.GAS;
        }
    }
}

