/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public abstract class SingleChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements ChemicalStackIngredient<CHEMICAL, STACK> {
    @NotNull
    private final List<STACK> representations;
    @NotNull
    private final STACK chemicalInstance;

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CLAZZ extends SingleChemicalStackIngredient<CHEMICAL, STACK>> Codec<CLAZZ> makeCodec(Codec<STACK> stackCodec, Function<STACK, CLAZZ> constructor) {
        return stackCodec.xmap(constructor, SingleChemicalStackIngredient::getChemicalInstance);
    }

    public SingleChemicalStackIngredient(@NotNull STACK chemicalInstance) {
        this.chemicalInstance = chemicalInstance;
        this.representations = Collections.singletonList(ChemicalUtil.copy(this.chemicalInstance));
    }

    protected abstract ChemicalIngredientInfo<CHEMICAL, STACK> getIngredientInfo();

    @Override
    public boolean test(@NotNull STACK chemicalStack) {
        return this.testType((CHEMICAL)chemicalStack) && ((ChemicalStack)chemicalStack).getAmount() >= ((ChemicalStack)this.chemicalInstance).getAmount();
    }

    @Override
    public boolean testType(@NotNull STACK chemicalStack) {
        return ((ChemicalStack)this.chemicalInstance).isTypeEqual((ChemicalStack)((ChemicalStack)Objects.requireNonNull(chemicalStack)));
    }

    @Override
    public boolean testType(@NotNull CHEMICAL chemical) {
        return ((ChemicalStack)this.chemicalInstance).isTypeEqual((Chemical)((Chemical)Objects.requireNonNull(chemical)));
    }

    @Override
    @NotNull
    public STACK getMatchingInstance(@NotNull STACK chemicalStack) {
        if (this.test(chemicalStack)) {
            return this.getIngredientInfo().createStack(this.chemicalInstance, ((ChemicalStack)this.chemicalInstance).getAmount());
        }
        return this.getIngredientInfo().getEmptyStack();
    }

    @Override
    public long getNeededAmount(@NotNull STACK stack) {
        return this.testType((CHEMICAL)stack) ? ((ChemicalStack)this.chemicalInstance).getAmount() : 0L;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return false;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull STACK> getRepresentations() {
        return this.representations;
    }

    public CHEMICAL getInputRaw() {
        return ((ChemicalStack)this.chemicalInstance).getType();
    }

    @NotNull
    public STACK getChemicalInstance() {
        return this.chemicalInstance;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)ChemicalIngredientDeserializer.IngredientType.SINGLE);
        ((ChemicalStack)this.chemicalInstance).writeToPacket(buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return ((ChemicalStack)this.chemicalInstance).equals(((SingleChemicalStackIngredient)o).chemicalInstance);
    }

    public int hashCode() {
        return ((ChemicalStack)this.chemicalInstance).hashCode();
    }
}

