/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.NotNull;

public abstract class TaggedChemicalStackIngredient<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements ChemicalStackIngredient<CHEMICAL, STACK> {
    @NotNull
    private final HolderSet.Named<CHEMICAL> tag;
    private final long amount;

    public static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, CLAZZ extends TaggedChemicalStackIngredient<CHEMICAL, STACK>> Codec<CLAZZ> makeCodec(ResourceKey<? extends Registry<CHEMICAL>> registry, BiFunction<TagKey<CHEMICAL>, Long, CLAZZ> constructor) {
        return RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)registry).fieldOf("tag").forGetter(TaggedChemicalStackIngredient::getTag), (App)SerializerHelper.POSITIVE_NONZERO_LONG_CODEC.fieldOf("amount").forGetter(TaggedChemicalStackIngredient::getRawAmount)).apply((Applicative)instance, constructor));
    }

    protected TaggedChemicalStackIngredient(@NotNull HolderSet.Named<CHEMICAL> tag, long amount) {
        this.tag = tag;
        this.amount = amount;
    }

    protected abstract ChemicalIngredientInfo<CHEMICAL, STACK> getIngredientInfo();

    @Override
    public boolean test(@NotNull STACK chemicalStack) {
        return this.testType((CHEMICAL)chemicalStack) && ((ChemicalStack)chemicalStack).getAmount() >= this.amount;
    }

    @Override
    public boolean testType(@NotNull STACK chemicalStack) {
        return this.testType((CHEMICAL)((ChemicalStack)Objects.requireNonNull(chemicalStack)).getType());
    }

    @Override
    public boolean testType(@NotNull CHEMICAL chemical) {
        return ((Chemical)Objects.requireNonNull(chemical)).is(this.getTag());
    }

    @Override
    @NotNull
    public STACK getMatchingInstance(@NotNull STACK chemicalStack) {
        if (this.test(chemicalStack)) {
            return this.getIngredientInfo().createStack(chemicalStack, this.amount);
        }
        return this.getIngredientInfo().getEmptyStack();
    }

    @Override
    public long getNeededAmount(@NotNull STACK stack) {
        return this.testType((CHEMICAL)stack) ? this.amount : 0L;
    }

    public long getRawAmount() {
        return this.amount;
    }

    @Override
    public boolean hasNoMatchingInstances() {
        return this.tag.size() == 0;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull STACK> getRepresentations() {
        ChemicalIngredientInfo<CHEMICAL, Chemical> ingredientInfo = this.getIngredientInfo();
        ArrayList<@NotNull Chemical> representations = new ArrayList<Chemical>();
        for (Holder chemical : this.tag) {
            representations.add(ingredientInfo.createStack((Chemical)chemical.value(), this.amount));
        }
        return representations;
    }

    public Iterable<Holder<CHEMICAL>> getRawInput() {
        return this.tag;
    }

    public TagKey<CHEMICAL> getTag() {
        return this.tag.key();
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)ChemicalIngredientDeserializer.IngredientType.TAGGED);
        buffer.writeResourceLocation(this.getTag().location());
        buffer.writeVarLong(this.amount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggedChemicalStackIngredient other = (TaggedChemicalStackIngredient)o;
        return this.amount == other.amount && this.tag.equals(other.tag);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.amount);
    }
}

