/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.creator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IFluidStackIngredientCreator;
import mekanism.common.recipe.ingredient.IMultiIngredient;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class FluidStackIngredientCreator
implements IFluidStackIngredientCreator {
    public static final FluidStackIngredientCreator INSTANCE = new FluidStackIngredientCreator();
    private static final Codec<FluidStackIngredient> SINGLE_CODEC = Codec.either(SingleFluidStackIngredient.CODEC, TaggedFluidStackIngredient.CODEC).xmap(either -> (FluidStackIngredient)either.map(Function.identity(), Function.identity()), input -> {
        if (input instanceof SingleFluidStackIngredient) {
            SingleFluidStackIngredient stack = (SingleFluidStackIngredient)input;
            return Either.left((Object)stack);
        }
        return Either.right((Object)((TaggedFluidStackIngredient)input));
    });
    private static final Codec<FluidStackIngredient> CODEC = Codec.either(SINGLE_CODEC, MultiFluidStackIngredient.CODEC).xmap(either -> (FluidStackIngredient)either.map(Function.identity(), multi -> {
        if (multi.ingredients.length == 1) {
            return multi.ingredients[0];
        }
        return multi;
    }), input -> {
        if (input instanceof MultiFluidStackIngredient) {
            MultiFluidStackIngredient multi = (MultiFluidStackIngredient)input;
            return Either.right((Object)multi);
        }
        return Either.left((Object)input);
    });

    private FluidStackIngredientCreator() {
    }

    @Override
    public Codec<FluidStackIngredient> codec() {
        return CODEC;
    }

    @Override
    public FluidStackIngredient from(FluidStack instance) {
        Objects.requireNonNull(instance, "FluidStackIngredients cannot be created from a null FluidStack.");
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created using the empty stack.");
        }
        return new SingleFluidStackIngredient(instance.copy());
    }

    @Override
    public FluidStackIngredient from(TagKey<Fluid> tag, int amount) {
        Objects.requireNonNull(tag, "FluidStackIngredients cannot be created from a null tag.");
        if (amount <= 0) {
            throw new IllegalArgumentException("FluidStackIngredients must have an amount of at least one. Received size was: " + amount);
        }
        return new TaggedFluidStackIngredient(tag, amount);
    }

    @Override
    public FluidStackIngredient read(FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "FluidStackIngredients cannot be read from a null packet buffer.");
        return switch ((IngredientType)buffer.readEnum(IngredientType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientType.SINGLE -> this.from(FluidStack.readFromPacket((FriendlyByteBuf)buffer));
            case IngredientType.TAGGED -> this.from(FluidTags.create((ResourceLocation)buffer.readResourceLocation()), buffer.readVarInt());
            case IngredientType.MULTI -> this.createMulti((FluidStackIngredient[])buffer.readArray(FluidStackIngredient[]::new, this::read));
        };
    }

    public FluidStackIngredient createMulti(FluidStackIngredient ... ingredients) {
        Objects.requireNonNull(ingredients, "Cannot create a multi ingredient out of a null array.");
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create a multi ingredient out of no ingredients.");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<FluidStackIngredient> cleanedIngredients = new ArrayList<FluidStackIngredient>();
        for (FluidStackIngredient ingredient : ingredients) {
            if (ingredient instanceof MultiFluidStackIngredient) {
                MultiFluidStackIngredient multi = (MultiFluidStackIngredient)ingredient;
                Collections.addAll(cleanedIngredients, multi.ingredients);
                continue;
            }
            cleanedIngredients.add(ingredient);
        }
        return new MultiFluidStackIngredient(cleanedIngredients.toArray(new FluidStackIngredient[0]));
    }

    @Override
    public FluidStackIngredient from(Stream<FluidStackIngredient> ingredients) {
        return this.createMulti((FluidStackIngredient[])ingredients.toArray(FluidStackIngredient[]::new));
    }

    @NothingNullByDefault
    public static class SingleFluidStackIngredient
    extends FluidStackIngredient {
        static final Codec<SingleFluidStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> SerializerHelper.FLUIDSTACK_CODEC.xmap(SingleFluidStackIngredient::new, SingleFluidStackIngredient::getInputRaw));
        private final List<@NotNull FluidStack> representations;
        private final FluidStack fluidInstance;

        private SingleFluidStackIngredient(FluidStack fluidInstance) {
            this.fluidInstance = Objects.requireNonNull(fluidInstance);
            this.representations = Collections.singletonList(this.fluidInstance.copy());
        }

        @Override
        public boolean test(FluidStack fluidStack) {
            return this.testType(fluidStack) && fluidStack.getAmount() >= this.fluidInstance.getAmount();
        }

        @Override
        public boolean testType(FluidStack fluidStack) {
            return Objects.requireNonNull(fluidStack).isFluidEqual(this.fluidInstance);
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack fluidStack) {
            return this.test(fluidStack) ? this.fluidInstance.copy() : FluidStack.EMPTY;
        }

        @Override
        public long getNeededAmount(FluidStack stack) {
            return this.testType(stack) ? (long)this.fluidInstance.getAmount() : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return false;
        }

        @Override
        public List<@NotNull FluidStack> getRepresentations() {
            return this.representations;
        }

        public FluidStack getInputRaw() {
            return this.fluidInstance;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)IngredientType.SINGLE);
            this.fluidInstance.writeToPacket(buffer);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleFluidStackIngredient other = (SingleFluidStackIngredient)o;
            return this.fluidInstance.isFluidStackIdentical(other.fluidInstance);
        }

        public int hashCode() {
            return this.fluidInstance.hashCode();
        }
    }

    @NothingNullByDefault
    public static class TaggedFluidStackIngredient
    extends FluidStackIngredient {
        static final Codec<TaggedFluidStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.FLUID).fieldOf("tag").forGetter(TaggedFluidStackIngredient::getTag), (App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(TaggedFluidStackIngredient::getRawAmount)).apply((Applicative)instance, TaggedFluidStackIngredient::new)));
        private final HolderSet.Named<Fluid> tag;
        private final int amount;

        private TaggedFluidStackIngredient(TagKey<Fluid> tag, int amount) {
            this((HolderSet.Named<Fluid>)BuiltInRegistries.FLUID.getOrCreateTag(tag), amount);
        }

        private TaggedFluidStackIngredient(HolderSet.Named<Fluid> tag, int amount) {
            this.tag = tag;
            this.amount = amount;
        }

        @Override
        public boolean test(FluidStack fluidStack) {
            return this.testType(fluidStack) && fluidStack.getAmount() >= this.amount;
        }

        @Override
        public boolean testType(FluidStack fluidStack) {
            return Objects.requireNonNull(fluidStack).is(this.getTag());
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack fluidStack) {
            if (this.test(fluidStack)) {
                return fluidStack.copyWithAmount(this.amount);
            }
            return FluidStack.EMPTY;
        }

        @Override
        public long getNeededAmount(FluidStack stack) {
            return this.testType(stack) ? (long)this.amount : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            return this.tag.size() == 0;
        }

        @Override
        public List<@NotNull FluidStack> getRepresentations() {
            ArrayList<@NotNull FluidStack> representations = new ArrayList<FluidStack>();
            for (Holder fluid : this.tag) {
                representations.add(new FluidStack(fluid, this.amount));
            }
            return representations;
        }

        public Iterable<Holder<Fluid>> getRawInput() {
            return this.tag;
        }

        public int getRawAmount() {
            return this.amount;
        }

        public TagKey<Fluid> getTag() {
            return this.tag.key();
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)IngredientType.TAGGED);
            buffer.writeResourceLocation(this.getTag().location());
            buffer.writeVarInt(this.amount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaggedFluidStackIngredient other = (TaggedFluidStackIngredient)o;
            return this.amount == other.amount && this.tag.equals(other.tag);
        }

        public int hashCode() {
            return Objects.hash(this.tag, this.amount);
        }
    }

    private static enum IngredientType {
        SINGLE,
        TAGGED,
        MULTI;

    }

    @NothingNullByDefault
    public static class MultiFluidStackIngredient
    extends FluidStackIngredient
    implements IMultiIngredient<FluidStack, FluidStackIngredient> {
        static final Codec<MultiFluidStackIngredient> CODEC = ExtraCodecs.nonEmptyList((Codec)SINGLE_CODEC.listOf()).xmap(lst -> new MultiFluidStackIngredient(lst.toArray(new FluidStackIngredient[0])), MultiFluidStackIngredient::getIngredients);
        private final FluidStackIngredient[] ingredients;

        private MultiFluidStackIngredient(FluidStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testType(FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                if (!ingredient.testType(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public FluidStack getMatchingInstance(FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                FluidStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return matchingInstance;
            }
            return FluidStack.EMPTY;
        }

        @Override
        public long getNeededAmount(FluidStack stack) {
            for (FluidStackIngredient ingredient : this.ingredients) {
                long amount = ingredient.getNeededAmount(stack);
                if (amount <= 0L) continue;
                return amount;
            }
            return 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            for (FluidStackIngredient ingredient : this.ingredients) {
                if (ingredient.hasNoMatchingInstances()) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<@NotNull FluidStack> getRepresentations() {
            ArrayList<@NotNull FluidStack> representations = new ArrayList<FluidStack>();
            for (FluidStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public boolean forEachIngredient(Predicate<FluidStackIngredient> checker) {
            boolean result = false;
            for (FluidStackIngredient ingredient : this.ingredients) {
                result |= checker.test(ingredient);
            }
            return result;
        }

        @Override
        public <DATA> boolean forEachIngredient(DATA data, BiPredicate<DATA, FluidStackIngredient> checker) {
            boolean result = false;
            for (FluidStackIngredient ingredient : this.ingredients) {
                result |= checker.test(data, ingredient);
            }
            return result;
        }

        @Override
        public final List<FluidStackIngredient> getIngredients() {
            return List.of(this.ingredients);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)IngredientType.MULTI);
            buffer.writeArray((Object[])this.ingredients, (buf, ingredient) -> ingredient.write((FriendlyByteBuf)buf));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.ingredients, ((MultiFluidStackIngredient)o).ingredients);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ingredients);
        }
    }
}

