/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.creator;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import mekanism.common.recipe.ingredient.chemical.MultiChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.SingleChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.TaggedChemicalStackIngredient;
import mekanism.common.recipe.ingredient.creator.ChemicalStackIngredientCreator;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

@NothingNullByDefault
public class InfusionStackIngredientCreator
extends ChemicalStackIngredientCreator<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> {
    public static final InfusionStackIngredientCreator INSTANCE = new InfusionStackIngredientCreator();

    private InfusionStackIngredientCreator() {
        super(SingleInfusionStackIngredient.CODEC, TaggedInfusionStackIngredient.CODEC, codec -> MultiChemicalStackIngredient.MultiInfusionStackIngredient.makeCodec(codec, MultiChemicalStackIngredient.MultiInfusionStackIngredient::new), SingleInfusionStackIngredient.class, TaggedInfusionStackIngredient.class, MultiChemicalStackIngredient.MultiInfusionStackIngredient.class, ChemicalStackIngredient.InfusionStackIngredient.class);
    }

    @Override
    protected ChemicalIngredientDeserializer<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> getDeserializer() {
        return ChemicalIngredientDeserializer.INFUSION;
    }

    @Override
    public ChemicalStackIngredient.InfusionStackIngredient from(IChemicalProvider<InfuseType> provider, long amount) {
        Objects.requireNonNull(provider, "InfusionStackIngredients cannot be created from a null chemical provider.");
        InfuseType infuseType = provider.getChemical();
        this.assertNonEmpty(infuseType);
        this.assertPositiveAmount(amount);
        return new SingleInfusionStackIngredient(infuseType.getStack(amount));
    }

    @Override
    public ChemicalStackIngredient.InfusionStackIngredient from(TagKey<InfuseType> tag, long amount) {
        Objects.requireNonNull(tag, "InfusionStackIngredients cannot be created from a null tag.");
        this.assertPositiveAmount(amount);
        return new TaggedInfusionStackIngredient(tag, amount);
    }

    @Override
    public ChemicalStackIngredient.InfusionStackIngredient from(Stream<ChemicalStackIngredient.InfusionStackIngredient> ingredients) {
        return (ChemicalStackIngredient.InfusionStackIngredient)this.createMulti((ChemicalStackIngredient.InfusionStackIngredient[])ingredients.toArray(ChemicalStackIngredient.InfusionStackIngredient[]::new));
    }

    public static class SingleInfusionStackIngredient
    extends SingleChemicalStackIngredient<InfuseType, InfusionStack>
    implements ChemicalStackIngredient.InfusionStackIngredient {
        static Codec<SingleInfusionStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> SingleInfusionStackIngredient.makeCodec(ChemicalUtils.INFUSION_STACK_CODEC, SingleInfusionStackIngredient::new));

        private SingleInfusionStackIngredient(InfusionStack stack) {
            super(stack);
        }

        @Override
        protected ChemicalIngredientInfo<InfuseType, InfusionStack> getIngredientInfo() {
            return ChemicalIngredientInfo.INFUSION;
        }
    }

    public static class TaggedInfusionStackIngredient
    extends TaggedChemicalStackIngredient<InfuseType, InfusionStack>
    implements ChemicalStackIngredient.InfusionStackIngredient {
        static Codec<TaggedInfusionStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> TaggedInfusionStackIngredient.makeCodec(MekanismAPI.INFUSE_TYPE_REGISTRY_NAME, TaggedInfusionStackIngredient::new));

        private TaggedInfusionStackIngredient(TagKey<InfuseType> tag, long amount) {
            super(MekanismAPI.INFUSE_TYPE_REGISTRY.getOrCreateTag(tag), amount);
        }

        @Override
        protected ChemicalIngredientInfo<InfuseType, InfusionStack> getIngredientInfo() {
            return ChemicalIngredientInfo.INFUSION;
        }
    }
}

