/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.creator;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IItemStackIngredientCreator;
import mekanism.common.recipe.ingredient.IMultiIngredient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class ItemStackIngredientCreator
implements IItemStackIngredientCreator {
    public static final ItemStackIngredientCreator INSTANCE = new ItemStackIngredientCreator();
    private final Codec<ItemStackIngredient> CODEC = Codec.either(SingleItemStackIngredient.CODEC, MultiItemStackIngredient.CODEC).xmap(either -> (ItemStackIngredient)either.map(Function.identity(), multi -> {
        if (multi.ingredients.length == 1) {
            return multi.ingredients[0];
        }
        return multi;
    }), stackIngredient -> {
        if (stackIngredient instanceof SingleItemStackIngredient) {
            SingleItemStackIngredient single = (SingleItemStackIngredient)stackIngredient;
            return Either.left((Object)single);
        }
        return Either.right((Object)((MultiItemStackIngredient)stackIngredient));
    });

    private ItemStackIngredientCreator() {
    }

    @Override
    public Codec<ItemStackIngredient> codec() {
        return this.CODEC;
    }

    @Override
    public ItemStackIngredient from(Ingredient ingredient, int amount) {
        Objects.requireNonNull(ingredient, "ItemStackIngredients cannot be created from a null ingredient.");
        if (ingredient == Ingredient.EMPTY) {
            throw new IllegalArgumentException("ItemStackIngredients cannot be created using the empty ingredient.");
        }
        if (amount <= 0) {
            throw new IllegalArgumentException("ItemStackIngredients must have an amount of at least one. Received size was: " + amount);
        }
        return new SingleItemStackIngredient(ingredient, amount);
    }

    @Override
    public ItemStackIngredient read(FriendlyByteBuf buffer) {
        Objects.requireNonNull(buffer, "ItemStackIngredients cannot be read from a null packet buffer.");
        return switch ((IngredientType)buffer.readEnum(IngredientType.class)) {
            default -> throw new IncompatibleClassChangeError();
            case IngredientType.SINGLE -> this.from(Ingredient.fromNetwork((FriendlyByteBuf)buffer), buffer.readVarInt());
            case IngredientType.MULTI -> this.createMulti((ItemStackIngredient[])buffer.readArray(ItemStackIngredient[]::new, this::read));
        };
    }

    public ItemStackIngredient createMulti(ItemStackIngredient ... ingredients) {
        Objects.requireNonNull(ingredients, "Cannot create a multi ingredient out of a null array.");
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("Cannot create a multi ingredient out of no ingredients.");
        }
        if (ingredients.length == 1) {
            return ingredients[0];
        }
        ArrayList<SingleItemStackIngredient> cleanedIngredients = new ArrayList<SingleItemStackIngredient>();
        for (ItemStackIngredient ingredient : ingredients) {
            if (ingredient instanceof MultiItemStackIngredient) {
                MultiItemStackIngredient multi = (MultiItemStackIngredient)ingredient;
                Collections.addAll(cleanedIngredients, multi.ingredients);
                continue;
            }
            if (ingredient instanceof SingleItemStackIngredient) {
                SingleItemStackIngredient single = (SingleItemStackIngredient)ingredient;
                cleanedIngredients.add(single);
                continue;
            }
            throw new IllegalStateException("Unknown ingredient class: " + ingredient);
        }
        return new MultiItemStackIngredient(cleanedIngredients.toArray(new SingleItemStackIngredient[0]));
    }

    @Override
    public ItemStackIngredient from(Stream<ItemStackIngredient> ingredients) {
        return this.createMulti((ItemStackIngredient[])ingredients.toArray(ItemStackIngredient[]::new));
    }

    @NothingNullByDefault
    public static class SingleItemStackIngredient
    extends ItemStackIngredient {
        static final Codec<SingleItemStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(SingleItemStackIngredient::getInputRaw), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("amount", (Object)1).forGetter(SingleItemStackIngredient::getAmountRaw)).apply((Applicative)i, SingleItemStackIngredient::new)));
        private final Ingredient ingredient;
        private final int amount;

        private SingleItemStackIngredient(Ingredient ingredient, int amount) {
            this.ingredient = Objects.requireNonNull(ingredient);
            this.amount = amount;
        }

        @Override
        public boolean test(ItemStack stack) {
            return this.testType(stack) && stack.getCount() >= this.amount;
        }

        @Override
        public boolean testType(ItemStack stack) {
            return this.ingredient.test(stack);
        }

        @Override
        public ItemStack getMatchingInstance(ItemStack stack) {
            return this.test(stack) ? stack.copyWithCount(this.amount) : ItemStack.EMPTY;
        }

        @Override
        public long getNeededAmount(ItemStack stack) {
            return this.testType(stack) ? (long)this.amount : 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            ItemStack[] items = this.ingredient.getItems();
            if (items.length == 0) {
                return true;
            }
            if (items.length == 1) {
                PlainTextContents contents;
                ComponentContents componentContents;
                ItemStack item = items[0];
                return item.getItem() == Items.BARRIER && (componentContents = item.getHoverName().getContents()) instanceof PlainTextContents && (contents = (PlainTextContents)componentContents).text().startsWith("Empty Tag: ");
            }
            return false;
        }

        @Override
        public List<@NotNull ItemStack> getRepresentations() {
            ArrayList<@NotNull ItemStack> representations = new ArrayList<ItemStack>();
            for (ItemStack stack : this.ingredient.getItems()) {
                if (stack.isEmpty()) continue;
                representations.add(stack.copyWithCount(this.amount));
            }
            return representations;
        }

        public Ingredient getInputRaw() {
            return this.ingredient;
        }

        public int getAmountRaw() {
            return this.amount;
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)IngredientType.SINGLE);
            this.ingredient.toNetwork(buffer);
            buffer.writeVarInt(this.amount);
        }
    }

    @NothingNullByDefault
    public static class MultiItemStackIngredient
    extends ItemStackIngredient
    implements IMultiIngredient<ItemStack, SingleItemStackIngredient> {
        static final Codec<MultiItemStackIngredient> CODEC = ExtraCodecs.nonEmptyList((Codec)SingleItemStackIngredient.CODEC.listOf()).xmap(lst -> new MultiItemStackIngredient(lst.toArray(new SingleItemStackIngredient[0])), MultiItemStackIngredient::getIngredients);
        private final SingleItemStackIngredient[] ingredients;

        private MultiItemStackIngredient(SingleItemStackIngredient ... ingredients) {
            this.ingredients = ingredients;
        }

        @Override
        public boolean test(ItemStack stack) {
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                if (!ingredient.test(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean testType(ItemStack stack) {
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                if (!ingredient.testType(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public ItemStack getMatchingInstance(ItemStack stack) {
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                ItemStack matchingInstance = ingredient.getMatchingInstance(stack);
                if (matchingInstance.isEmpty()) continue;
                return matchingInstance;
            }
            return ItemStack.EMPTY;
        }

        @Override
        public long getNeededAmount(ItemStack stack) {
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                long amount = ingredient.getNeededAmount(stack);
                if (amount <= 0L) continue;
                return amount;
            }
            return 0L;
        }

        @Override
        public boolean hasNoMatchingInstances() {
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                if (ingredient.hasNoMatchingInstances()) continue;
                return false;
            }
            return true;
        }

        @Override
        public List<@NotNull ItemStack> getRepresentations() {
            ArrayList<@NotNull ItemStack> representations = new ArrayList<ItemStack>();
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                representations.addAll(ingredient.getRepresentations());
            }
            return representations;
        }

        @Override
        public boolean forEachIngredient(Predicate<SingleItemStackIngredient> checker) {
            boolean result = false;
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                result |= checker.test(ingredient);
            }
            return result;
        }

        @Override
        public <DATA> boolean forEachIngredient(DATA data, BiPredicate<DATA, SingleItemStackIngredient> checker) {
            boolean result = false;
            for (SingleItemStackIngredient ingredient : this.ingredients) {
                result |= checker.test(data, ingredient);
            }
            return result;
        }

        @Override
        public final List<SingleItemStackIngredient> getIngredients() {
            return List.of(this.ingredients);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeEnum((Enum)IngredientType.MULTI);
            buffer.writeArray((Object[])this.ingredients, (buf, ingredient) -> ingredient.write((FriendlyByteBuf)buf));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return Arrays.equals(this.ingredients, ((MultiItemStackIngredient)o).ingredients);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ingredients);
        }
    }

    private static enum IngredientType {
        SINGLE,
        MULTI;

    }
}

