/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.creator;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import mekanism.common.recipe.ingredient.chemical.MultiChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.SingleChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.TaggedChemicalStackIngredient;
import mekanism.common.recipe.ingredient.creator.ChemicalStackIngredientCreator;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

@NothingNullByDefault
public class PigmentStackIngredientCreator
extends ChemicalStackIngredientCreator<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> {
    public static final PigmentStackIngredientCreator INSTANCE = new PigmentStackIngredientCreator();

    private PigmentStackIngredientCreator() {
        super(SinglePigmentStackIngredient.CODEC, TaggedPigmentStackIngredient.CODEC, codec -> MultiChemicalStackIngredient.MultiPigmentStackIngredient.makeCodec(codec, MultiChemicalStackIngredient.MultiPigmentStackIngredient::new), SinglePigmentStackIngredient.class, TaggedPigmentStackIngredient.class, MultiChemicalStackIngredient.MultiPigmentStackIngredient.class, ChemicalStackIngredient.PigmentStackIngredient.class);
    }

    @Override
    protected ChemicalIngredientDeserializer<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> getDeserializer() {
        return ChemicalIngredientDeserializer.PIGMENT;
    }

    @Override
    public ChemicalStackIngredient.PigmentStackIngredient from(IChemicalProvider<Pigment> provider, long amount) {
        Objects.requireNonNull(provider, "PigmentStackIngredients cannot be created from a null chemical provider.");
        Pigment pigment = provider.getChemical();
        this.assertNonEmpty(pigment);
        this.assertPositiveAmount(amount);
        return new SinglePigmentStackIngredient(pigment.getStack(amount));
    }

    @Override
    public ChemicalStackIngredient.PigmentStackIngredient from(TagKey<Pigment> tag, long amount) {
        Objects.requireNonNull(tag, "PigmentStackIngredients cannot be created from a null tag.");
        this.assertPositiveAmount(amount);
        return new TaggedPigmentStackIngredient(tag, amount);
    }

    @Override
    public ChemicalStackIngredient.PigmentStackIngredient from(Stream<ChemicalStackIngredient.PigmentStackIngredient> ingredients) {
        return (ChemicalStackIngredient.PigmentStackIngredient)this.createMulti((ChemicalStackIngredient.PigmentStackIngredient[])ingredients.toArray(ChemicalStackIngredient.PigmentStackIngredient[]::new));
    }

    public static class SinglePigmentStackIngredient
    extends SingleChemicalStackIngredient<Pigment, PigmentStack>
    implements ChemicalStackIngredient.PigmentStackIngredient {
        static Codec<SinglePigmentStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> SinglePigmentStackIngredient.makeCodec(ChemicalUtils.PIGMENT_STACK_CODEC, SinglePigmentStackIngredient::new));

        private SinglePigmentStackIngredient(PigmentStack stack) {
            super(stack);
        }

        @Override
        protected ChemicalIngredientInfo<Pigment, PigmentStack> getIngredientInfo() {
            return ChemicalIngredientInfo.PIGMENT;
        }
    }

    public static class TaggedPigmentStackIngredient
    extends TaggedChemicalStackIngredient<Pigment, PigmentStack>
    implements ChemicalStackIngredient.PigmentStackIngredient {
        static Codec<TaggedPigmentStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> TaggedPigmentStackIngredient.makeCodec(MekanismAPI.PIGMENT_REGISTRY_NAME, TaggedPigmentStackIngredient::new));

        private TaggedPigmentStackIngredient(TagKey<Pigment> tag, long amount) {
            super(MekanismAPI.PIGMENT_REGISTRY.getOrCreateTag(tag), amount);
        }

        @Override
        protected ChemicalIngredientInfo<Pigment, PigmentStack> getIngredientInfo() {
            return ChemicalIngredientInfo.PIGMENT;
        }
    }
}

