/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.ingredient.creator;

import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.stream.Stream;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientInfo;
import mekanism.common.recipe.ingredient.chemical.MultiChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.SingleChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.TaggedChemicalStackIngredient;
import mekanism.common.recipe.ingredient.creator.ChemicalStackIngredientCreator;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;

@NothingNullByDefault
public class SlurryStackIngredientCreator
extends ChemicalStackIngredientCreator<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient> {
    public static final SlurryStackIngredientCreator INSTANCE = new SlurryStackIngredientCreator();

    private SlurryStackIngredientCreator() {
        super(SingleSlurryStackIngredient.CODEC, TaggedSlurryStackIngredient.CODEC, codec -> MultiChemicalStackIngredient.MultiSlurryStackIngredient.makeCodec(codec, MultiChemicalStackIngredient.MultiSlurryStackIngredient::new), SingleSlurryStackIngredient.class, TaggedSlurryStackIngredient.class, MultiChemicalStackIngredient.MultiSlurryStackIngredient.class, ChemicalStackIngredient.SlurryStackIngredient.class);
    }

    @Override
    protected ChemicalIngredientDeserializer<Slurry, SlurryStack, ChemicalStackIngredient.SlurryStackIngredient> getDeserializer() {
        return ChemicalIngredientDeserializer.SLURRY;
    }

    @Override
    public ChemicalStackIngredient.SlurryStackIngredient from(IChemicalProvider<Slurry> provider, long amount) {
        Objects.requireNonNull(provider, "SlurryStackIngredients cannot be created from a null chemical provider.");
        Slurry slurry = provider.getChemical();
        this.assertNonEmpty(slurry);
        this.assertPositiveAmount(amount);
        return new SingleSlurryStackIngredient(slurry.getStack(amount));
    }

    @Override
    public ChemicalStackIngredient.SlurryStackIngredient from(TagKey<Slurry> tag, long amount) {
        Objects.requireNonNull(tag, "SlurryStackIngredients cannot be created from a null tag.");
        this.assertPositiveAmount(amount);
        return new TaggedSlurryStackIngredient(tag, amount);
    }

    @Override
    public ChemicalStackIngredient.SlurryStackIngredient from(Stream<ChemicalStackIngredient.SlurryStackIngredient> ingredients) {
        return (ChemicalStackIngredient.SlurryStackIngredient)this.createMulti((ChemicalStackIngredient.SlurryStackIngredient[])ingredients.toArray(ChemicalStackIngredient.SlurryStackIngredient[]::new));
    }

    public static class SingleSlurryStackIngredient
    extends SingleChemicalStackIngredient<Slurry, SlurryStack>
    implements ChemicalStackIngredient.SlurryStackIngredient {
        static Codec<SingleSlurryStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> SingleSlurryStackIngredient.makeCodec(ChemicalUtils.SLURRY_STACK_CODEC, SingleSlurryStackIngredient::new));

        private SingleSlurryStackIngredient(SlurryStack stack) {
            super(stack);
        }

        @Override
        protected ChemicalIngredientInfo<Slurry, SlurryStack> getIngredientInfo() {
            return ChemicalIngredientInfo.SLURRY;
        }
    }

    public static class TaggedSlurryStackIngredient
    extends TaggedChemicalStackIngredient<Slurry, SlurryStack>
    implements ChemicalStackIngredient.SlurryStackIngredient {
        static Codec<TaggedSlurryStackIngredient> CODEC = ExtraCodecs.lazyInitializedCodec(() -> TaggedSlurryStackIngredient.makeCodec(MekanismAPI.SLURRY_REGISTRY_NAME, TaggedSlurryStackIngredient::new));

        private TaggedSlurryStackIngredient(TagKey<Slurry> tag, long amount) {
            super(MekanismAPI.SLURRY_REGISTRY.getOrCreateTag(tag), amount);
        }

        @Override
        protected ChemicalIngredientInfo<Slurry, SlurryStack> getIngredientInfo() {
            return ChemicalIngredientInfo.SLURRY;
        }
    }
}

