/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup;

import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.common.recipe.lookup.IRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.SingleInputRecipeCache;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public interface ISingleRecipeLookupHandler<INPUT, RECIPE extends MekanismRecipe, INPUT_CACHE extends SingleInputRecipeCache<INPUT, ?, RECIPE, ?>>
extends IRecipeLookupHandler.IRecipeTypedLookupHandler<RECIPE, INPUT_CACHE> {
    default public boolean containsRecipe(INPUT input) {
        return ((SingleInputRecipeCache)this.getRecipeType().getInputCache()).containsInput(this.getLevel(), input);
    }

    @Nullable
    default public RECIPE findFirstRecipe(INPUT input) {
        return ((SingleInputRecipeCache)this.getRecipeType().getInputCache()).findFirstRecipe(this.getLevel(), input);
    }

    @Nullable
    default public RECIPE findFirstRecipe(IInputHandler<INPUT> inputHandler) {
        return this.findFirstRecipe(inputHandler.getInput());
    }

    public static interface ChemicalRecipeLookupHandler<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends MekanismRecipe>
    extends ISingleRecipeLookupHandler<STACK, RECIPE, InputRecipeCache.SingleChemical<CHEMICAL, STACK, RECIPE>> {
        @Override
        default public boolean containsRecipe(CHEMICAL input) {
            return this.containsRecipe((CHEMICAL)ChemicalUtil.withAmount(input, 1L));
        }
    }

    public static interface FluidRecipeLookupHandler<RECIPE extends MekanismRecipe>
    extends ISingleRecipeLookupHandler<FluidStack, RECIPE, InputRecipeCache.SingleFluid<RECIPE>> {
    }

    public static interface ItemRecipeLookupHandler<RECIPE extends MekanismRecipe>
    extends ISingleRecipeLookupHandler<ItemStack, RECIPE, InputRecipeCache.SingleItem<RECIPE>> {
    }
}

