/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractInputRecipeCache<RECIPE extends MekanismRecipe>
implements IInputRecipeCache {
    protected final MekanismRecipeType<RECIPE, ?> recipeType;
    protected boolean initialized;

    protected AbstractInputRecipeCache(MekanismRecipeType<RECIPE, ?> recipeType) {
        this.recipeType = recipeType;
    }

    @Override
    public void clear() {
        this.initialized = false;
    }

    protected void initCacheIfNeeded(@Nullable Level world) {
        if (!this.initialized) {
            this.initialized = true;
            this.initCache(this.recipeType.getRecipes(world));
        }
    }

    protected abstract void initCache(List<RecipeHolder<RECIPE>> var1);

    protected <INPUT, INGREDIENT extends InputIngredient<INPUT>, CACHE extends IInputCache<INPUT, INGREDIENT, RECIPE>> boolean containsInput(@Nullable Level world, INPUT input, Function<RECIPE, INGREDIENT> inputExtractor, CACHE cache, Set<RECIPE> complexRecipes) {
        if (cache.isEmpty(input)) {
            return false;
        }
        this.initCacheIfNeeded(world);
        if (cache.contains(input)) {
            return true;
        }
        for (MekanismRecipe recipe : complexRecipes) {
            if (!((InputIngredient)inputExtractor.apply(recipe)).testType(input)) continue;
            return true;
        }
        return false;
    }

    protected <INPUT_1, INGREDIENT_1 extends InputIngredient<INPUT_1>, CACHE_1 extends IInputCache<INPUT_1, INGREDIENT_1, RECIPE>, INPUT_2, INGREDIENT_2 extends InputIngredient<INPUT_2>, CACHE_2 extends IInputCache<INPUT_2, INGREDIENT_2, RECIPE>> boolean containsPairing(@Nullable Level world, INPUT_1 input1, Function<RECIPE, INGREDIENT_1> input1Extractor, CACHE_1 cache1, Set<RECIPE> complexIngredients1, INPUT_2 input2, Function<RECIPE, INGREDIENT_2> input2Extractor, CACHE_2 cache2, Set<RECIPE> complexIngredients2) {
        if (cache1.isEmpty(input1)) {
            return this.containsInput(world, input2, input2Extractor, cache2, complexIngredients2);
        }
        if (cache2.isEmpty(input2)) {
            return true;
        }
        this.initCacheIfNeeded(world);
        for (MekanismRecipe recipe : cache1.getRecipes(input1)) {
            if (!((InputIngredient)input2Extractor.apply(recipe)).testType(input2)) continue;
            return true;
        }
        for (MekanismRecipe recipe : complexIngredients1) {
            if (!((InputIngredient)input1Extractor.apply(recipe)).testType(input1) || !((InputIngredient)input2Extractor.apply(recipe)).testType(input2)) continue;
            return true;
        }
        return false;
    }
}

