/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.ChemicalInputCache;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.EnumUtils;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ChemicalCrystallizerInputRecipeCache
extends AbstractInputRecipeCache<ChemicalCrystallizerRecipe> {
    private final Map<ChemicalType, ChemicalInputCache<?, ?, ChemicalCrystallizerRecipe>> typeBasedCache = new EnumMap(ChemicalType.class);
    private final Map<ChemicalType, Set<ChemicalCrystallizerRecipe>> typeBasedComplexRecipes = new EnumMap<ChemicalType, Set<ChemicalCrystallizerRecipe>>(ChemicalType.class);

    public ChemicalCrystallizerInputRecipeCache(MekanismRecipeType<ChemicalCrystallizerRecipe, ?> recipeType) {
        super(recipeType);
        for (ChemicalType chemicalType : EnumUtils.CHEMICAL_TYPES) {
            this.typeBasedCache.put(chemicalType, new ChemicalInputCache());
            this.typeBasedComplexRecipes.put(chemicalType, new HashSet());
        }
    }

    @Override
    public void clear() {
        super.clear();
        for (ChemicalType chemicalType : EnumUtils.CHEMICAL_TYPES) {
            this.typeBasedCache.get((Object)chemicalType).clear();
            this.typeBasedComplexRecipes.get((Object)chemicalType).clear();
        }
    }

    public boolean containsInput(@Nullable Level world, BoxedChemicalStack input) {
        if (input.isEmpty()) {
            return false;
        }
        this.initCacheIfNeeded(world);
        ChemicalType type = input.getChemicalType();
        if (this.containsInput(type, input.getChemicalStack())) {
            return true;
        }
        for (ChemicalCrystallizerRecipe recipe : this.typeBasedComplexRecipes.get((Object)type)) {
            if (!recipe.testType(input)) continue;
            return true;
        }
        return false;
    }

    public <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean containsInput(@Nullable Level world, CHEMICAL input) {
        if (input.isEmptyType()) {
            return false;
        }
        this.initCacheIfNeeded(world);
        ChemicalType type = ChemicalType.getTypeFor(input);
        Object stack = ChemicalUtil.withAmount(input, 1L);
        if (this.containsInput(type, stack)) {
            return true;
        }
        for (ChemicalCrystallizerRecipe recipe : this.typeBasedComplexRecipes.get((Object)type)) {
            if (!recipe.testType((ChemicalStack<?>)stack)) continue;
            return true;
        }
        return false;
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> boolean containsInput(ChemicalType type, STACK stack) {
        return this.typeBasedCache.get((Object)type).contains(stack);
    }

    @Nullable
    public ChemicalCrystallizerRecipe findFirstRecipe(@Nullable Level world, BoxedChemicalStack input) {
        if (input.isEmpty()) {
            return null;
        }
        this.initCacheIfNeeded(world);
        return this.findFirstRecipe(input.getChemicalType(), input.getChemicalStack());
    }

    @Nullable
    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> ChemicalCrystallizerRecipe findFirstRecipe(ChemicalType type, STACK stack) {
        ChemicalInputCache<?, ?, ChemicalCrystallizerRecipe> cache = this.typeBasedCache.get((Object)type);
        ChemicalCrystallizerRecipe recipe = this.findFirstRecipe(stack, cache.getRecipes(stack));
        return recipe == null ? this.findFirstRecipe(stack, (Iterable<ChemicalCrystallizerRecipe>)this.typeBasedComplexRecipes.get((Object)type)) : recipe;
    }

    @Nullable
    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> ChemicalCrystallizerRecipe findFirstRecipe(STACK input, Iterable<ChemicalCrystallizerRecipe> recipes) {
        for (ChemicalCrystallizerRecipe recipe : recipes) {
            if (!recipe.getInput().test(input)) continue;
            return recipe;
        }
        return null;
    }

    @Override
    protected void initCache(List<RecipeHolder<ChemicalCrystallizerRecipe>> recipes) {
        for (RecipeHolder<ChemicalCrystallizerRecipe> recipeHolder : recipes) {
            ChemicalStackIngredient<?, ?> ingredient;
            ChemicalType type;
            ChemicalCrystallizerRecipe recipe = (ChemicalCrystallizerRecipe)recipeHolder.value();
            if (!this.mapInputs(recipe, type = ChemicalType.getTypeFor(ingredient = recipe.getInput()), ingredient)) continue;
            this.typeBasedComplexRecipes.get((Object)type).add(recipe);
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>> boolean mapInputs(ChemicalCrystallizerRecipe recipe, ChemicalType type, INGREDIENT ingredient) {
        return this.typeBasedCache.get((Object)type).mapInputs(recipe, ingredient);
    }
}

