/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInputCache<KEY, INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe>
implements IInputCache<INPUT, INGREDIENT, RECIPE> {
    private final Map<KEY, Set<RECIPE>> inputCache = new HashMap<KEY, Set<RECIPE>>();

    @Override
    public void clear() {
        this.inputCache.clear();
    }

    @Override
    public boolean contains(INPUT input) {
        return this.inputCache.containsKey(this.createKey(input));
    }

    @Override
    public boolean contains(INPUT input, Predicate<RECIPE> matchCriteria) {
        for (MekanismRecipe recipe : this.getRecipes(input)) {
            if (!matchCriteria.test(recipe)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public RECIPE findFirstRecipe(INPUT input, Predicate<RECIPE> matchCriteria) {
        for (MekanismRecipe recipe : this.getRecipes(input)) {
            if (!matchCriteria.test(recipe)) continue;
            return (RECIPE)recipe;
        }
        return null;
    }

    @Override
    public Iterable<RECIPE> getRecipes(INPUT input) {
        return this.inputCache.getOrDefault(this.createKey(input), Collections.emptySet());
    }

    protected abstract KEY createKey(INPUT var1);

    protected void addInputCache(KEY input, RECIPE recipe) {
        this.inputCache.computeIfAbsent(input, i -> new HashSet()).add(recipe);
    }

    protected void addInputCache(Holder<KEY> input, RECIPE recipe) {
        this.addInputCache(input.value(), recipe);
    }
}

