/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.common.recipe.ingredient.creator.FluidStackIngredientCreator;
import mekanism.common.recipe.lookup.cache.type.NBTSensitiveInputCache;
import net.minecraft.core.Holder;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidInputCache<RECIPE extends MekanismRecipe>
extends NBTSensitiveInputCache<Fluid, FluidStack, FluidStack, FluidStackIngredient, RECIPE> {
    @Override
    public boolean mapInputs(RECIPE recipe, FluidStackIngredient inputIngredient) {
        if (inputIngredient instanceof FluidStackIngredientCreator.SingleFluidStackIngredient) {
            FluidStackIngredientCreator.SingleFluidStackIngredient single = (FluidStackIngredientCreator.SingleFluidStackIngredient)inputIngredient;
            this.addNbtInputCache(single.getInputRaw(), recipe);
        } else if (inputIngredient instanceof FluidStackIngredientCreator.TaggedFluidStackIngredient) {
            FluidStackIngredientCreator.TaggedFluidStackIngredient tagged = (FluidStackIngredientCreator.TaggedFluidStackIngredient)inputIngredient;
            for (Holder<Fluid> input : tagged.getRawInput()) {
                this.addInputCache(input, recipe);
            }
        } else {
            if (inputIngredient instanceof FluidStackIngredientCreator.MultiFluidStackIngredient) {
                FluidStackIngredientCreator.MultiFluidStackIngredient multi = (FluidStackIngredientCreator.MultiFluidStackIngredient)inputIngredient;
                return this.mapMultiInputs(recipe, multi);
            }
            return true;
        }
        return false;
    }

    @Override
    protected Fluid createKey(FluidStack stack) {
        return stack.getFluid();
    }

    @Override
    protected FluidStack createNbtKey(FluidStack stack) {
        return stack;
    }

    @Override
    public boolean isEmpty(FluidStack input) {
        return input.isEmpty();
    }
}

