/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache.type;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.lookup.cache.type.BaseInputCache;

public abstract class NBTSensitiveInputCache<KEY, NBT_KEY, INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe>
extends BaseInputCache<KEY, INPUT, INGREDIENT, RECIPE> {
    private final Map<NBT_KEY, Set<RECIPE>> nbtInputCache = new HashMap<NBT_KEY, Set<RECIPE>>();

    @Override
    public void clear() {
        super.clear();
        this.nbtInputCache.clear();
    }

    @Override
    public boolean contains(INPUT input) {
        return this.nbtInputCache.containsKey(this.createNbtKey(input)) || super.contains(input);
    }

    @Override
    public Iterable<RECIPE> getRecipes(INPUT input) {
        Set nbtRecipes = this.nbtInputCache.getOrDefault(this.createNbtKey(input), Collections.emptySet());
        if (nbtRecipes.isEmpty()) {
            return super.getRecipes(input);
        }
        Collection basicRecipes = (Collection)super.getRecipes(input);
        if (basicRecipes.isEmpty()) {
            return nbtRecipes;
        }
        return Iterables.concat(nbtRecipes, (Iterable)basicRecipes);
    }

    protected abstract NBT_KEY createNbtKey(INPUT var1);

    protected void addNbtInputCache(NBT_KEY input, RECIPE recipe) {
        this.nbtInputCache.computeIfAbsent(input, i -> new HashSet()).add(recipe);
    }
}

