/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.chemical.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public abstract class ChemicalChemicalToChemicalRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory;
    private final Codec<STACK> stackCodec;
    private Codec<RECIPE> codec;

    protected ChemicalChemicalToChemicalRecipeSerializer(IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory, Codec<STACK> stackCodec) {
        this.factory = factory;
        this.stackCodec = stackCodec;
    }

    protected abstract ChemicalIngredientDeserializer<CHEMICAL, STACK, INGREDIENT> getDeserializer();

    protected abstract STACK fromBuffer(@NotNull FriendlyByteBuf var1);

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            Codec<INGREDIENT> ingredientCodec = this.getDeserializer().codec();
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)ingredientCodec.fieldOf("leftInput").forGetter(rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getLeftInput()), (App)ingredientCodec.fieldOf("rightInput").forGetter(rec$ -> ((ChemicalChemicalToChemicalRecipe)rec$).getRightInput()), (App)this.stackCodec.fieldOf("output").forGetter(rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw())).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        INGREDIENT leftInput = this.getDeserializer().read(buffer);
        INGREDIENT rightInput = this.getDeserializer().read(buffer);
        STACK output = this.fromBuffer(buffer);
        return this.factory.create(leftInput, rightInput, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((ChemicalChemicalToChemicalRecipe)recipe).getLeftInput().write(buffer);
        ((ChemicalChemicalToChemicalRecipe)recipe).getRightInput().write(buffer);
        ((ChemicalStack)((IBasicChemicalOutput)recipe).getOutputRaw()).writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ChemicalChemicalToChemicalRecipe<CHEMICAL, STACK, INGREDIENT>> {
        public RECIPE create(INGREDIENT var1, INGREDIENT var2, STACK var3);
    }
}

