/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.codec.DependentMapCodec;
import mekanism.api.recipes.basic.BasicChemicalCrystallizerRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ChemicalCrystallizerRecipeSerializer
implements RecipeSerializer<BasicChemicalCrystallizerRecipe> {
    private final IFactory<BasicChemicalCrystallizerRecipe> factory;
    private Codec<BasicChemicalCrystallizerRecipe> codec;
    private static final MapCodec<ChemicalType> chemicalTypeMapCodec = ChemicalType.CODEC.fieldOf("chemicalType");
    private static final MapCodec<ChemicalStackIngredient<?, ?>> chemicalStackIngredientMapEncoder = new DependentMapCodec<ChemicalStackIngredient, ChemicalType>("input", type -> IngredientCreatorAccess.getCreatorForType(type).codec(), chemicalTypeMapCodec, ChemicalType::getTypeFor);

    public ChemicalCrystallizerRecipeSerializer(IFactory<BasicChemicalCrystallizerRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicChemicalCrystallizerRecipe> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)chemicalStackIngredientMapEncoder.forGetter(BasicChemicalCrystallizerRecipe::getInput), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(BasicChemicalCrystallizerRecipe::getOutputRaw)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public BasicChemicalCrystallizerRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ChemicalType chemicalType = (ChemicalType)buffer.readEnum(ChemicalType.class);
        ChemicalStackIngredient inputIngredient = (ChemicalStackIngredient)IngredientCreatorAccess.getCreatorForType(chemicalType).read(buffer);
        ItemStack output = buffer.readItem();
        return this.factory.create(inputIngredient, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicChemicalCrystallizerRecipe recipe) {
        buffer.writeEnum((Enum)recipe.getChemicalType());
        recipe.getInput().write(buffer);
        buffer.writeItem(recipe.getOutputRaw());
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicChemicalCrystallizerRecipe> {
        public RECIPE create(ChemicalStackIngredient<?, ?> var1, ItemStack var2);
    }
}

