/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.merged.BoxedChemicalStack;
import mekanism.api.recipes.ChemicalDissolutionRecipe;
import mekanism.api.recipes.basic.BasicChemicalDissolutionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ChemicalDissolutionRecipeSerializer
implements RecipeSerializer<BasicChemicalDissolutionRecipe> {
    private final IFactory<BasicChemicalDissolutionRecipe> factory;
    private Codec<BasicChemicalDissolutionRecipe> codec;

    public ChemicalDissolutionRecipeSerializer(IFactory<BasicChemicalDissolutionRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicChemicalDissolutionRecipe> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("itemInput").forGetter(ChemicalDissolutionRecipe::getItemInput), (App)IngredientCreatorAccess.gas().codec().fieldOf("gasInput").forGetter(ChemicalDissolutionRecipe::getGasInput), (App)SerializerHelper.BOXED_CHEMICALSTACK_CODEC.fieldOf("output").forGetter(r -> r.getOutputRaw().getChemicalStack())).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public BasicChemicalDissolutionRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient itemInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        ChemicalStackIngredient.GasStackIngredient gasInput = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
        BoxedChemicalStack boxedChemicalStack = BoxedChemicalStack.read(buffer);
        return this.factory.create(itemInput, gasInput, boxedChemicalStack.getChemicalStack());
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicChemicalDissolutionRecipe recipe) {
        recipe.getItemInput().write(buffer);
        recipe.getGasInput().write(buffer);
        recipe.getOutputRaw().write(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicChemicalDissolutionRecipe> {
        public RECIPE create(ItemStackIngredient var1, ChemicalStackIngredient.GasStackIngredient var2, ChemicalStack<?> var3);
    }
}

