/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.basic.BasicCombinerRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class CombinerRecipeSerializer
implements RecipeSerializer<BasicCombinerRecipe> {
    private final IFactory<BasicCombinerRecipe> factory;
    private Codec<BasicCombinerRecipe> codec;

    public CombinerRecipeSerializer(IFactory<BasicCombinerRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicCombinerRecipe> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("mainInput").forGetter(CombinerRecipe::getMainInput), (App)IngredientCreatorAccess.item().codec().fieldOf("extraInput").forGetter(CombinerRecipe::getExtraInput), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(BasicCombinerRecipe::getOutputRaw)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public BasicCombinerRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient mainInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        ItemStackIngredient extraInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        ItemStack output = buffer.readItem();
        return this.factory.create(mainInput, extraInput, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicCombinerRecipe recipe) {
        recipe.getMainInput().write(buffer);
        recipe.getExtraInput().write(buffer);
        buffer.writeItem(recipe.getOutputRaw());
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicCombinerRecipe> {
        public RECIPE create(ItemStackIngredient var1, ItemStackIngredient var2, ItemStack var3);
    }
}

