/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.basic.BasicElectrolysisRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ElectrolysisRecipeSerializer
implements RecipeSerializer<BasicElectrolysisRecipe> {
    private static final Codec<FloatingLong> FLOAT_LONG_AT_LEAST_ONE = ExtraCodecs.validate(FloatingLong.CODEC, fl -> fl.smallerThan(FloatingLong.ONE) ? DataResult.error(() -> "Expected energyMultiplier to be at least one.") : DataResult.success((Object)fl));
    private final IFactory<BasicElectrolysisRecipe> factory;
    private Codec<BasicElectrolysisRecipe> codec;

    public ElectrolysisRecipeSerializer(IFactory<BasicElectrolysisRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicElectrolysisRecipe> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.fluid().codec().fieldOf("input").forGetter(ElectrolysisRecipe::getInput), (App)FLOAT_LONG_AT_LEAST_ONE.optionalFieldOf("energyMultiplier", (Object)FloatingLong.ONE).forGetter(ElectrolysisRecipe::getEnergyMultiplier), (App)ChemicalUtils.GAS_STACK_CODEC.fieldOf("leftGasOutput").forGetter(BasicElectrolysisRecipe::getLeftGasOutput), (App)ChemicalUtils.GAS_STACK_CODEC.fieldOf("rightGasOutput").forGetter(BasicElectrolysisRecipe::getRightGasOutput)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public BasicElectrolysisRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        FluidStackIngredient input = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        FloatingLong energyMultiplier = FloatingLong.readFromBuffer(buffer);
        GasStack leftGasOutput = GasStack.readFromPacket(buffer);
        GasStack rightGasOutput = GasStack.readFromPacket(buffer);
        return this.factory.create(input, energyMultiplier, leftGasOutput, rightGasOutput);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicElectrolysisRecipe recipe) {
        recipe.getInput().write(buffer);
        recipe.getEnergyMultiplier().writeToBuffer(buffer);
        recipe.getLeftGasOutput().writeToPacket(buffer);
        recipe.getRightGasOutput().writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicElectrolysisRecipe> {
        public RECIPE create(FluidStackIngredient var1, FloatingLong var2, GasStack var3, GasStack var4);
    }
}

