/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.recipes.FluidSlurryToSlurryRecipe;
import mekanism.api.recipes.basic.BasicFluidSlurryToSlurryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class FluidSlurryToSlurryRecipeSerializer
implements RecipeSerializer<BasicFluidSlurryToSlurryRecipe> {
    private final IFactory<BasicFluidSlurryToSlurryRecipe> factory;
    private Codec<BasicFluidSlurryToSlurryRecipe> codec;

    public FluidSlurryToSlurryRecipeSerializer(IFactory<BasicFluidSlurryToSlurryRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicFluidSlurryToSlurryRecipe> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.fluid().codec().fieldOf("fluidInput").forGetter(FluidSlurryToSlurryRecipe::getFluidInput), (App)IngredientCreatorAccess.slurry().codec().fieldOf("slurryInput").forGetter(FluidSlurryToSlurryRecipe::getChemicalInput), (App)ChemicalUtils.SLURRY_STACK_CODEC.fieldOf("output").forGetter(BasicFluidSlurryToSlurryRecipe::getOutputRaw)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public BasicFluidSlurryToSlurryRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        FluidStackIngredient fluidInput = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        ChemicalStackIngredient.SlurryStackIngredient slurryInput = (ChemicalStackIngredient.SlurryStackIngredient)IngredientCreatorAccess.slurry().read(buffer);
        SlurryStack output = SlurryStack.readFromPacket(buffer);
        return this.factory.create(fluidInput, slurryInput, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicFluidSlurryToSlurryRecipe recipe) {
        recipe.getFluidInput().write(buffer);
        recipe.getChemicalInput().write(buffer);
        recipe.getOutputRaw().writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends FluidSlurryToSlurryRecipe> {
        public RECIPE create(FluidStackIngredient var1, ChemicalStackIngredient.SlurryStackIngredient var2, SlurryStack var3);
    }
}

