/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.api.recipes.basic.BasicFluidToFluidRecipe;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidToFluidRecipeSerializer<RECIPE extends BasicFluidToFluidRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;
    private Codec<RECIPE> codec;

    public FluidToFluidRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.fluid().codec().fieldOf("input").forGetter(FluidToFluidRecipe::getInput), (App)SerializerHelper.FLUIDSTACK_CODEC.fieldOf("output").forGetter(BasicFluidToFluidRecipe::getOutputRaw)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        FluidStackIngredient inputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        FluidStack output = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        return (RECIPE)((BasicFluidToFluidRecipe)this.factory.create(inputIngredient, output));
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((BasicFluidToFluidRecipe)recipe).getInput().write(buffer);
        ((BasicFluidToFluidRecipe)recipe).getOutputRaw().writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends FluidToFluidRecipe> {
        public RECIPE create(FluidStackIngredient var1, FluidStack var2);
    }
}

