/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.basic.BasicGasToGasRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class GasToGasRecipeSerializer<RECIPE extends BasicGasToGasRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;
    private Codec<RECIPE> codec;

    public GasToGasRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.gas().codec().fieldOf("input").forGetter(GasToGasRecipe::getInput), (App)ChemicalUtils.GAS_STACK_CODEC.fieldOf("output").forGetter(BasicGasToGasRecipe::getOutputRaw)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ChemicalStackIngredient.GasStackIngredient inputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
        GasStack output = GasStack.readFromPacket(buffer);
        return (RECIPE)((BasicGasToGasRecipe)this.factory.create(inputIngredient, output));
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((BasicGasToGasRecipe)recipe).getInput().write(buffer);
        ((BasicGasToGasRecipe)recipe).getOutputRaw().writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends GasToGasRecipe> {
        public RECIPE create(ChemicalStackIngredient.GasStackIngredient var1, GasStack var2);
    }
}

