/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.basic.IBasicItemStackOutput;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.ingredient.chemical.ChemicalIngredientDeserializer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public abstract class ItemStackChemicalToItemStackRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory;
    private Codec<RECIPE> codec;

    protected ItemStackChemicalToItemStackRecipeSerializer(IFactory<CHEMICAL, STACK, INGREDIENT, RECIPE> factory) {
        this.factory = factory;
    }

    protected abstract ChemicalIngredientDeserializer<CHEMICAL, STACK, INGREDIENT> getDeserializer();

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("itemInput").forGetter(rec$ -> ((ItemStackChemicalToItemStackRecipe)rec$).getItemInput()), (App)this.getDeserializer().codec().fieldOf("chemicalInput").forGetter(rec$ -> ((ItemStackChemicalToItemStackRecipe)rec$).getChemicalInput()), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(rec$ -> ((IBasicItemStackOutput)rec$).getOutputRaw())).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient itemInput = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        INGREDIENT chemicalInput = this.getDeserializer().read(buffer);
        ItemStack output = buffer.readItem();
        return this.factory.create(itemInput, chemicalInput, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((ItemStackChemicalToItemStackRecipe)recipe).getItemInput().write(buffer);
        ((ItemStackChemicalToItemStackRecipe)recipe).getChemicalInput().write(buffer);
        buffer.writeItem(((IBasicItemStackOutput)recipe).getOutputRaw());
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>> {
        public RECIPE create(ItemStackIngredient var1, INGREDIENT var2, ItemStack var3);
    }
}

