/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.basic.IBasicChemicalOutput;
import mekanism.api.recipes.chemical.ItemStackToChemicalRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public abstract class ItemStackToChemicalRecipeSerializer<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<CHEMICAL, STACK, RECIPE> factory;
    private Codec<RECIPE> codec;
    private final Codec<STACK> stackCodec;

    protected ItemStackToChemicalRecipeSerializer(IFactory<CHEMICAL, STACK, RECIPE> factory, Codec<STACK> stackCodec) {
        this.factory = factory;
        this.stackCodec = stackCodec;
    }

    protected abstract STACK stackFromBuffer(@NotNull FriendlyByteBuf var1);

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("input").forGetter(rec$ -> ((ItemStackToChemicalRecipe)rec$).getInput()), (App)this.stackCodec.fieldOf("output").forGetter(rec$ -> ((IBasicChemicalOutput)rec$).getOutputRaw())).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        STACK output = this.stackFromBuffer(buffer);
        return this.factory.create(inputIngredient, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((ItemStackToChemicalRecipe)recipe).getInput().write(buffer);
        ((ChemicalStack)((IBasicChemicalOutput)recipe).getOutputRaw()).writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, RECIPE extends ItemStackToChemicalRecipe<CHEMICAL, STACK>> {
        public RECIPE create(ItemStackIngredient var1, STACK var2);
    }
}

