/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ItemStackToEnergyRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ItemStackToEnergyRecipeSerializer<RECIPE extends ItemStackToEnergyRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;
    private Codec<RECIPE> codec;

    public ItemStackToEnergyRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("input").forGetter(ItemStackToEnergyRecipe::getInput), (App)FloatingLong.NONZERO_CODEC.fieldOf("output").forGetter(r -> r.getOutput(ItemStack.EMPTY))).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        FloatingLong output = FloatingLong.readFromBuffer(buffer);
        return this.factory.create(inputIngredient, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((ItemStackToEnergyRecipe)recipe).getInput().write(buffer);
        ((ItemStackToEnergyRecipe)recipe).getOutput(ItemStack.EMPTY).writeToBuffer(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends ItemStackToEnergyRecipe> {
        public RECIPE create(ItemStackIngredient var1, FloatingLong var2);
    }
}

