/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.recipes.basic.BasicItemStackToItemStackRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class ItemStackToItemStackRecipeSerializer<RECIPE extends BasicItemStackToItemStackRecipe>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;
    private Codec<RECIPE> codec;

    public ItemStackToItemStackRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("input").forGetter(BasicItemStackToItemStackRecipe::getInput), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(BasicItemStackToItemStackRecipe::getOutputRaw)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        ItemStack output = buffer.readItem();
        return this.factory.create(inputIngredient, output);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        ((BasicItemStackToItemStackRecipe)recipe).getInput().write(buffer);
        buffer.writeItem(((BasicItemStackToItemStackRecipe)recipe).getOutputRaw());
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicItemStackToItemStackRecipe> {
        public RECIPE create(ItemStackIngredient var1, ItemStack var2);
    }
}

