/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.basic.BasicNucleosynthesizingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class NucleosynthesizingRecipeSerializer
implements RecipeSerializer<BasicNucleosynthesizingRecipe> {
    private final IFactory<BasicNucleosynthesizingRecipe> factory;
    private Codec<BasicNucleosynthesizingRecipe> codec;

    public NucleosynthesizingRecipeSerializer(IFactory<BasicNucleosynthesizingRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicNucleosynthesizingRecipe> codec() {
        if (this.codec == null) {
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("itemInput").forGetter(NucleosynthesizingRecipe::getItemInput), (App)IngredientCreatorAccess.gas().codec().fieldOf("gasInput").forGetter(NucleosynthesizingRecipe::getChemicalInput), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(BasicNucleosynthesizingRecipe::getOutputRaw), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(NucleosynthesizingRecipe::getDuration)).apply((Applicative)instance, this.factory::create));
        }
        return this.codec;
    }

    @NotNull
    public BasicNucleosynthesizingRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient inputSolid = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        ChemicalStackIngredient.GasStackIngredient inputGas = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
        ItemStack outputItem = buffer.readItem();
        int duration = buffer.readVarInt();
        return this.factory.create(inputSolid, inputGas, outputItem, duration);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicNucleosynthesizingRecipe recipe) {
        recipe.getItemInput().write(buffer);
        recipe.getChemicalInput().write(buffer);
        buffer.writeItem(recipe.getOutputRaw());
        buffer.writeVarInt(recipe.getDuration());
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicNucleosynthesizingRecipe> {
        public RECIPE create(ItemStackIngredient var1, ChemicalStackIngredient.GasStackIngredient var2, ItemStack var3, int var4);
    }
}

