/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.PressurizedReactionRecipe;
import mekanism.api.recipes.basic.BasicPressurizedReactionRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class PressurizedReactionRecipeSerializer
implements RecipeSerializer<BasicPressurizedReactionRecipe> {
    private final IFactory<BasicPressurizedReactionRecipe> factory;
    private Codec<BasicPressurizedReactionRecipe> codec;

    public PressurizedReactionRecipeSerializer(IFactory<BasicPressurizedReactionRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicPressurizedReactionRecipe> codec() {
        if (this.codec == null) {
            Codec baseCodec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("itemInput").forGetter(PressurizedReactionRecipe::getInputSolid), (App)IngredientCreatorAccess.fluid().codec().fieldOf("fluidInput").forGetter(PressurizedReactionRecipe::getInputFluid), (App)IngredientCreatorAccess.gas().codec().fieldOf("gasInput").forGetter(PressurizedReactionRecipe::getInputGas), (App)FloatingLong.CODEC.optionalFieldOf("energyRequired", (Object)FloatingLong.ZERO).forGetter(PressurizedReactionRecipe::getEnergyRequired), (App)ExtraCodecs.POSITIVE_INT.fieldOf("duration").forGetter(PressurizedReactionRecipe::getDuration), (App)ItemStack.ITEM_WITH_COUNT_CODEC.optionalFieldOf("itemOutput", (Object)ItemStack.EMPTY).forGetter(BasicPressurizedReactionRecipe::getOutputItem), (App)ChemicalUtils.GAS_STACK_CODEC.optionalFieldOf("gasOutput", (Object)GasStack.EMPTY).forGetter(BasicPressurizedReactionRecipe::getOutputGas)).apply((Applicative)instance, this.factory::create));
            this.codec = ExtraCodecs.validate((Codec)baseCodec, result -> {
                if (result.getOutputItem().isEmpty() && result.getOutputGas().isEmpty()) {
                    return DataResult.error(() -> "No output specified, must have at least and Item or Gas output");
                }
                return DataResult.success((Object)result);
            });
        }
        return this.codec;
    }

    @NotNull
    public BasicPressurizedReactionRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient inputSolid = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        FluidStackIngredient inputFluid = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
        ChemicalStackIngredient.GasStackIngredient inputGas = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
        FloatingLong energyRequired = FloatingLong.readFromBuffer(buffer);
        int duration = buffer.readVarInt();
        ItemStack outputItem = buffer.readItem();
        GasStack outputGas = GasStack.readFromPacket(buffer);
        return this.factory.create(inputSolid, inputFluid, inputGas, energyRequired, duration, outputItem, outputGas);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicPressurizedReactionRecipe recipe) {
        recipe.getInputSolid().write(buffer);
        recipe.getInputFluid().write(buffer);
        recipe.getInputGas().write(buffer);
        recipe.getEnergyRequired().writeToBuffer(buffer);
        buffer.writeVarInt(recipe.getDuration());
        buffer.writeItem(recipe.getOutputItem());
        recipe.getOutputGas().writeToPacket(buffer);
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicPressurizedReactionRecipe> {
        public RECIPE create(ItemStackIngredient var1, FluidStackIngredient var2, ChemicalStackIngredient.GasStackIngredient var3, FloatingLong var4, int var5, ItemStack var6, GasStack var7);
    }
}

