/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mekanism.api.SerializerHelper;
import mekanism.api.chemical.ChemicalUtils;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.basic.BasicRotaryRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.recipe.ingredient.creator.FluidStackIngredientCreator;
import mekanism.common.recipe.ingredient.creator.GasStackIngredientCreator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class RotaryRecipeSerializer
implements RecipeSerializer<BasicRotaryRecipe> {
    private final RecordCodecBuilder<BasicRotaryRecipe, FluidStackIngredient> FLUID_INPUT_FIELD = ExtraCodecs.validate(FluidStackIngredientCreator.INSTANCE.codec(), ingredient -> ingredient == null ? DataResult.error(() -> "Fluid input may not be empty") : DataResult.success((Object)ingredient)).fieldOf("fluidInput").forGetter(BasicRotaryRecipe::getFluidInputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, FluidStack> FLUID_OUTPUT_FIELD = ExtraCodecs.validate(SerializerHelper.FLUIDSTACK_CODEC, stack -> stack.isEmpty() ? DataResult.error(() -> "Fluid output may not be empty") : DataResult.success((Object)stack)).fieldOf("fluidOutput").forGetter(BasicRotaryRecipe::getFluidOutputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, ChemicalStackIngredient.GasStackIngredient> GAS_INPUT_FIELD = ExtraCodecs.validate(GasStackIngredientCreator.INSTANCE.codec(), ingredient -> ingredient == null ? DataResult.error(() -> "Gas input may not be empty") : DataResult.success((Object)ingredient)).fieldOf("gasInput").forGetter(BasicRotaryRecipe::getGasInputRaw);
    private final RecordCodecBuilder<BasicRotaryRecipe, GasStack> GAS_OUTPUT_FIELD = ExtraCodecs.validate(ChemicalUtils.GAS_STACK_CODEC, stack -> stack.isEmpty() ? DataResult.error(() -> "Gas output may not be empty") : DataResult.success((Object)stack)).fieldOf("gasOutput").forGetter(BasicRotaryRecipe::getGasOutputRaw);
    private final BasicRotaryRecipe.Factory factory;
    private Codec<BasicRotaryRecipe> codec;

    private MapCodec<BasicRotaryRecipe> bothWaysCodec() {
        return RecordCodecBuilder.mapCodec(i -> i.group(this.FLUID_INPUT_FIELD, this.GAS_INPUT_FIELD, this.GAS_OUTPUT_FIELD, this.FLUID_OUTPUT_FIELD).apply((Applicative)i, this.factory::create));
    }

    private MapCodec<BasicRotaryRecipe> fluidToGasCodec() {
        return RecordCodecBuilder.mapCodec(i -> i.group(this.FLUID_INPUT_FIELD, this.GAS_OUTPUT_FIELD).apply((Applicative)i, this.factory::create));
    }

    private MapCodec<BasicRotaryRecipe> gasToFluidCodec() {
        return RecordCodecBuilder.mapCodec(i -> i.group(this.GAS_INPUT_FIELD, this.FLUID_OUTPUT_FIELD).apply((Applicative)i, this.factory::create));
    }

    public RotaryRecipeSerializer(BasicRotaryRecipe.Factory factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicRotaryRecipe> codec() {
        if (this.codec == null) {
            this.codec = NeoForgeExtraCodecs.withAlternative(this.bothWaysCodec(), (MapCodec)NeoForgeExtraCodecs.withAlternative(this.fluidToGasCodec(), this.gasToFluidCodec())).codec();
        }
        return this.codec;
    }

    @NotNull
    public BasicRotaryRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        boolean hasGasToFluid;
        FluidStackIngredient fluidInputIngredient = null;
        ChemicalStackIngredient.GasStackIngredient gasInputIngredient = null;
        GasStack gasOutput = null;
        FluidStack fluidOutput = null;
        boolean hasFluidToGas = buffer.readBoolean();
        if (hasFluidToGas) {
            fluidInputIngredient = (FluidStackIngredient)IngredientCreatorAccess.fluid().read(buffer);
            gasOutput = GasStack.readFromPacket(buffer);
        }
        if (hasGasToFluid = buffer.readBoolean()) {
            gasInputIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            fluidOutput = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
        }
        if (hasFluidToGas && hasGasToFluid) {
            return this.factory.create(fluidInputIngredient, gasInputIngredient, gasOutput, fluidOutput);
        }
        if (hasFluidToGas) {
            return this.factory.create(fluidInputIngredient, gasOutput);
        }
        if (hasGasToFluid) {
            return this.factory.create(gasInputIngredient, fluidOutput);
        }
        throw new IllegalStateException("A recipe got sent with no conversion in either direction.");
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicRotaryRecipe recipe) {
        buffer.writeBoolean(recipe.hasFluidToGas());
        if (recipe.hasFluidToGas()) {
            recipe.getFluidInput().write(buffer);
            recipe.getGasOutputRaw().writeToPacket(buffer);
        }
        buffer.writeBoolean(recipe.hasGasToFluid());
        if (recipe.hasGasToFluid()) {
            recipe.getGasInput().write(buffer);
            recipe.getFluidOutputRaw().writeToPacket(buffer);
        }
    }

    public static interface IFactory<RECIPE extends BasicRotaryRecipe> {
        public RECIPE create(FluidStackIngredient var1, GasStack var2);

        public RECIPE create(ChemicalStackIngredient.GasStackIngredient var1, FluidStack var2);

        public RECIPE create(FluidStackIngredient var1, ChemicalStackIngredient.GasStackIngredient var2, GasStack var3, FluidStack var4);
    }
}

