/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.basic.BasicSawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class SawmillRecipeSerializer
implements RecipeSerializer<BasicSawmillRecipe> {
    private final IFactory<BasicSawmillRecipe> factory;
    private Codec<BasicSawmillRecipe> codec;

    public SawmillRecipeSerializer(IFactory<BasicSawmillRecipe> factory) {
        this.factory = factory;
    }

    @NotNull
    public Codec<BasicSawmillRecipe> codec() {
        if (this.codec == null) {
            Codec chanceCodec = ExtraCodecs.validate((Codec)Codec.DOUBLE, d -> d > 0.0 && d <= 1.0 ? DataResult.success((Object)d) : DataResult.error(() -> "Expected secondaryChance to be greater than zero, and less than or equal to one. Found " + d));
            MapCodec secondaryChanceFieldBase = ExtraCodecs.strictOptionalField((Codec)chanceCodec, (String)"secondaryChance");
            MapCodec mainOutputFieldBase = ItemStack.ITEM_WITH_COUNT_CODEC.optionalFieldOf("mainOutput");
            RecordCodecBuilder secondaryOutputField = ItemStack.ITEM_WITH_COUNT_CODEC.optionalFieldOf("secondaryOutput").forGetter(BasicSawmillRecipe::getSecondaryOutputRaw);
            this.codec = RecordCodecBuilder.create(instance -> instance.group((App)IngredientCreatorAccess.item().codec().fieldOf("input").forGetter(SawmillRecipe::getInput), SerializerHelper.oneRequired(secondaryOutputField, mainOutputFieldBase, BasicSawmillRecipe::getMainOutputRaw), (App)secondaryOutputField, SerializerHelper.dependentOptionality(secondaryOutputField, secondaryChanceFieldBase, sawmillRecipe -> {
                double secondaryChance = sawmillRecipe.getSecondaryChance();
                return secondaryChance == 0.0 ? Optional.empty() : Optional.of(secondaryChance);
            })).apply((Applicative)instance, (input, mainOutput, secondaryOutput, secondChance) -> this.factory.create((ItemStackIngredient)input, mainOutput.orElse(ItemStack.EMPTY), secondaryOutput.orElse(ItemStack.EMPTY), secondChance.orElse(0.0))));
        }
        return this.codec;
    }

    @NotNull
    public BasicSawmillRecipe fromNetwork(@NotNull FriendlyByteBuf buffer) {
        ItemStackIngredient inputIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
        ItemStack mainOutput = buffer.readItem();
        ItemStack secondaryOutput = buffer.readItem();
        double secondaryChance = buffer.readDouble();
        return this.factory.create(inputIngredient, mainOutput, secondaryOutput, secondaryChance);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull BasicSawmillRecipe recipe) {
        recipe.getInput().write(buffer);
        buffer.writeItem(recipe.getMainOutputRaw().orElse(ItemStack.EMPTY));
        buffer.writeItem(recipe.getSecondaryOutputRaw().orElse(ItemStack.EMPTY));
        buffer.writeDouble(recipe.getSecondaryChance());
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends BasicSawmillRecipe> {
        public RECIPE create(ItemStackIngredient var1, ItemStack var2, ItemStack var3, double var4);
    }
}

