/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import mekanism.common.recipe.WrappedShapedRecipe;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import org.jetbrains.annotations.NotNull;

public class WrappedShapedRecipeSerializer<RECIPE extends WrappedShapedRecipe>
implements RecipeSerializer<RECIPE> {
    private final Function<ShapedRecipe, RECIPE> wrapper;
    private Codec<RECIPE> codec;

    public WrappedShapedRecipeSerializer(Function<ShapedRecipe, RECIPE> wrapper) {
        this.wrapper = wrapper;
    }

    @NotNull
    public Codec<RECIPE> codec() {
        if (this.codec == null) {
            this.codec = ((MapCodec.MapCodecCodec)RecipeSerializer.SHAPED_RECIPE.codec()).codec().xmap(this.wrapper, WrappedShapedRecipe::getInternal).codec();
        }
        return this.codec;
    }

    @NotNull
    public RECIPE fromNetwork(@NotNull FriendlyByteBuf buffer) {
        return (RECIPE)((WrappedShapedRecipe)this.wrapper.apply((ShapedRecipe)RecipeSerializer.SHAPED_RECIPE.fromNetwork(buffer)));
    }

    public void toNetwork(@NotNull FriendlyByteBuf buffer, @NotNull RECIPE recipe) {
        RecipeSerializer.SHAPED_RECIPE.toNetwork(buffer, (Recipe)((WrappedShapedRecipe)recipe).getInternal());
    }
}

