/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.fluid.ExtendedFluidHandlerUtils;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class FluidRecipeData
implements RecipeUpgradeData<FluidRecipeData> {
    private final List<IExtendedFluidTank> fluidTanks;

    FluidRecipeData(List<IExtendedFluidTank> fluidTanks) {
        this.fluidTanks = fluidTanks;
    }

    @Override
    @Nullable
    public FluidRecipeData merge(FluidRecipeData other) {
        ArrayList<IExtendedFluidTank> allTanks = new ArrayList<IExtendedFluidTank>(this.fluidTanks);
        allTanks.addAll(other.fluidTanks);
        return new FluidRecipeData(allTanks);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.fluidTanks.isEmpty()) {
            return true;
        }
        IMekanismFluidHandler outputHandler = ContainerType.FLUID.getAttachment((IAttachmentHolder)stack);
        if (outputHandler == null) {
            return false;
        }
        for (IExtendedFluidTank fluidTank : this.fluidTanks) {
            if (fluidTank.isEmpty() || this.insertManualIntoOutputContainer(outputHandler, fluidTank.getFluid()).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private FluidStack insertManualIntoOutputContainer(IMekanismFluidHandler outputHandler, FluidStack fluid) {
        return ExtendedFluidHandlerUtils.insert(fluid, null, outputHandler::getFluidTanks, Action.EXECUTE, AutomationType.MANUAL);
    }
}

