/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.recipe.WrappedShapedRecipe;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.registries.MekanismRecipeSerializersInternal;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@NothingNullByDefault
public class MekanismShapedRecipe
extends WrappedShapedRecipe {
    public MekanismShapedRecipe(ShapedRecipe internal) {
        super(internal);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializersInternal.MEK_DATA.get();
    }

    @Override
    public ItemStack assemble(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack resultItem = this.getResultItem(registryAccess);
        if (resultItem.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack toReturn = resultItem.copy();
        ArrayList<ItemStack> attachmentInputs = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty() || !stack.hasAttachments()) continue;
            attachmentInputs.add(stack);
        }
        if (attachmentInputs.isEmpty()) {
            return toReturn;
        }
        Set<RecipeUpgradeType> supportedTypes = RecipeUpgradeData.getSupportedTypes(toReturn);
        if (supportedTypes.isEmpty()) {
            return toReturn;
        }
        EnumMap<RecipeUpgradeType, List> upgradeInfo = new EnumMap<RecipeUpgradeType, List>(RecipeUpgradeType.class);
        for (ItemStack itemStack : attachmentInputs) {
            Set<RecipeUpgradeType> stackSupportedTypes = RecipeUpgradeData.getSupportedTypes(itemStack);
            for (RecipeUpgradeType supportedType : stackSupportedTypes) {
                RecipeUpgradeData<?> data;
                if (!supportedTypes.contains((Object)supportedType) || (data = RecipeUpgradeData.getUpgradeData(supportedType, itemStack)) == null) continue;
                upgradeInfo.computeIfAbsent(supportedType, type -> new ArrayList()).add(data);
            }
        }
        for (Map.Entry entry : upgradeInfo.entrySet()) {
            Object data;
            List upgradeData = (List)entry.getValue();
            if (upgradeData.isEmpty() || (data = RecipeUpgradeData.mergeUpgradeData(upgradeData)) != null && data.applyToStack(toReturn)) continue;
            return ItemStack.EMPTY;
        }
        return toReturn;
    }
}

