/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.UUID;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.common.attachments.DriveMetadata;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class QIORecipeData
implements RecipeUpgradeData<QIORecipeData> {
    private final Object2LongMap<UUID> itemMap;
    private final long itemCount;

    QIORecipeData(DriveMetadata data) {
        this.itemCount = data.count();
        this.itemMap = data.namedItemMap();
    }

    private QIORecipeData(Object2LongMap<UUID> itemMap, long itemCount) {
        this.itemMap = itemMap;
        this.itemCount = itemCount;
    }

    @Override
    @Nullable
    public QIORecipeData merge(QIORecipeData other) {
        if (this.itemCount <= Long.MAX_VALUE - other.itemCount) {
            Object2LongMap<UUID> smallerMap = other.itemMap;
            Object2LongMap<UUID> largerMap = this.itemMap;
            if (largerMap.size() < smallerMap.size()) {
                smallerMap = this.itemMap;
                largerMap = other.itemMap;
            }
            Object2LongOpenHashMap fullItemMap = new Object2LongOpenHashMap(largerMap);
            for (Object2LongMap.Entry entry : smallerMap.object2LongEntrySet()) {
                fullItemMap.mergeLong((Object)((UUID)entry.getKey()), entry.getLongValue(), Long::sum);
            }
            return new QIORecipeData((Object2LongMap<UUID>)fullItemMap, this.itemCount + other.itemCount);
        }
        return null;
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.itemMap.isEmpty()) {
            return this.itemCount == 0L;
        }
        IQIODriveItem driveItem = (IQIODriveItem)stack.getItem();
        if (this.itemCount == 0L || this.itemCount > driveItem.getCountCapacity(stack) || this.itemMap.size() > driveItem.getTypeCapacity(stack)) {
            return false;
        }
        ((DriveMetadata)stack.getData(MekanismAttachmentTypes.DRIVE_METADATA)).update(this.itemMap, this.itemCount);
        return true;
    }
}

