/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import mekanism.api.Upgrade;
import mekanism.api.annotations.ParametersAreNotNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.security.IItemSecurityUtils;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.SecurityMode;
import mekanism.common.attachments.DriveMetadata;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.attribute.AttributeUpgradeSupport;
import mekanism.common.content.qio.IQIODriveItem;
import mekanism.common.inventory.slot.BinInventorySlot;
import mekanism.common.item.block.ItemBlockBin;
import mekanism.common.item.block.ItemBlockPersonalStorage;
import mekanism.common.item.block.machine.ItemBlockFactory;
import mekanism.common.lib.inventory.personalstorage.PersonalStorageManager;
import mekanism.common.recipe.upgrade.EnergyRecipeData;
import mekanism.common.recipe.upgrade.FluidRecipeData;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.recipe.upgrade.LockRecipeData;
import mekanism.common.recipe.upgrade.QIORecipeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeType;
import mekanism.common.recipe.upgrade.SecurityRecipeData;
import mekanism.common.recipe.upgrade.SortingRecipeData;
import mekanism.common.recipe.upgrade.UpgradesRecipeData;
import mekanism.common.recipe.upgrade.chemical.GasRecipeData;
import mekanism.common.recipe.upgrade.chemical.InfusionRecipeData;
import mekanism.common.recipe.upgrade.chemical.PigmentRecipeData;
import mekanism.common.recipe.upgrade.chemical.SlurryRecipeData;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.tier.BinTier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNotNullByDefault
public interface RecipeUpgradeData<TYPE extends RecipeUpgradeData<TYPE>> {
    @Nullable
    public TYPE merge(TYPE var1);

    public boolean applyToStack(ItemStack var1);

    @NotNull
    public static Set<RecipeUpgradeType> getSupportedTypes(ItemStack stack) {
        ItemBlockBin bin;
        BlockItem blockItem;
        if (stack.isEmpty()) {
            return Collections.emptySet();
        }
        EnumSet<RecipeUpgradeType> supportedTypes = EnumSet.noneOf(RecipeUpgradeType.class);
        Item item = stack.getItem();
        if (item instanceof BlockItem && Attribute.has((blockItem = (BlockItem)item).getBlock(), AttributeUpgradeSupport.class)) {
            supportedTypes.add(RecipeUpgradeType.UPGRADE);
        }
        if (ContainerType.ENERGY.supports(stack)) {
            supportedTypes.add(RecipeUpgradeType.ENERGY);
        }
        if (ContainerType.FLUID.supports(stack)) {
            supportedTypes.add(RecipeUpgradeType.FLUID);
        }
        if (ContainerType.GAS.supports(stack)) {
            supportedTypes.add(RecipeUpgradeType.GAS);
        }
        if (ContainerType.INFUSION.supports(stack)) {
            supportedTypes.add(RecipeUpgradeType.INFUSION);
        }
        if (ContainerType.PIGMENT.supports(stack)) {
            supportedTypes.add(RecipeUpgradeType.PIGMENT);
        }
        if (ContainerType.SLURRY.supports(stack)) {
            supportedTypes.add(RecipeUpgradeType.SLURRY);
        }
        if (ContainerType.ITEM.supports(stack) || item instanceof ItemBlockPersonalStorage) {
            supportedTypes.add(RecipeUpgradeType.ITEM);
        }
        if (IItemSecurityUtils.INSTANCE.ownerCapability(stack) != null) {
            supportedTypes.add(RecipeUpgradeType.SECURITY);
        }
        if (item instanceof ItemBlockBin && (bin = (ItemBlockBin)item).getTier() != BinTier.CREATIVE) {
            supportedTypes.add(RecipeUpgradeType.LOCK);
        }
        if (item instanceof ItemBlockFactory) {
            supportedTypes.add(RecipeUpgradeType.SORTING);
        }
        if (item instanceof IQIODriveItem) {
            supportedTypes.add(RecipeUpgradeType.QIO_DRIVE);
        }
        return supportedTypes;
    }

    @Nullable
    private static <CONTAINER extends INBTSerializable<CompoundTag>, TYPE extends RecipeUpgradeData<TYPE>> TYPE getContainerUpgradeData(@NotNull ItemStack stack, ContainerType<CONTAINER, ?, ?> containerType, Function<List<CONTAINER>, TYPE> creator) {
        List<CONTAINER> containers = containerType.getAttachmentContainersIfPresent((IAttachmentHolder)stack);
        return (TYPE)(containers.isEmpty() ? null : (RecipeUpgradeData)creator.apply(containers));
    }

    @Nullable
    public static RecipeUpgradeData<?> getUpgradeData(@NotNull RecipeUpgradeType type, @NotNull ItemStack stack) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case RecipeUpgradeType.ENERGY -> RecipeUpgradeData.getContainerUpgradeData(stack, ContainerType.ENERGY, EnergyRecipeData::new);
            case RecipeUpgradeType.FLUID -> RecipeUpgradeData.getContainerUpgradeData(stack, ContainerType.FLUID, FluidRecipeData::new);
            case RecipeUpgradeType.GAS -> RecipeUpgradeData.getContainerUpgradeData(stack, ContainerType.GAS, GasRecipeData::new);
            case RecipeUpgradeType.INFUSION -> RecipeUpgradeData.getContainerUpgradeData(stack, ContainerType.INFUSION, InfusionRecipeData::new);
            case RecipeUpgradeType.PIGMENT -> RecipeUpgradeData.getContainerUpgradeData(stack, ContainerType.PIGMENT, PigmentRecipeData::new);
            case RecipeUpgradeType.SLURRY -> RecipeUpgradeData.getContainerUpgradeData(stack, ContainerType.SLURRY, SlurryRecipeData::new);
            case RecipeUpgradeType.ITEM -> {
                List<IInventorySlot> slots = stack.getItem() instanceof ItemBlockPersonalStorage ? PersonalStorageManager.getInventoryIfPresent(stack).map(inv -> inv.getInventorySlots(null)).orElse(Collections.emptyList()) : ContainerType.ITEM.getAttachmentContainersIfPresent((IAttachmentHolder)stack);
                if (slots.isEmpty()) {
                    yield null;
                }
                yield new ItemRecipeData(slots);
            }
            case RecipeUpgradeType.LOCK -> {
                BinInventorySlot slot = BinInventorySlot.getForStack(stack);
                if (slot == null || !slot.isLocked()) {
                    yield null;
                }
                yield new LockRecipeData(slot);
            }
            case RecipeUpgradeType.SECURITY -> {
                UUID ownerUUID = IItemSecurityUtils.INSTANCE.getOwnerUUID(stack);
                if (ownerUUID == null) {
                    yield null;
                }
                ISecurityObject securityObject = IItemSecurityUtils.INSTANCE.securityCapability(stack);
                SecurityMode securityMode = securityObject == null ? SecurityMode.PUBLIC : securityObject.getSecurityMode();
                yield new SecurityRecipeData(ownerUUID, securityMode);
            }
            case RecipeUpgradeType.SORTING -> {
                if (((Boolean)stack.getData(MekanismAttachmentTypes.SORTING)).booleanValue()) {
                    yield SortingRecipeData.SORTING;
                }
                yield null;
            }
            case RecipeUpgradeType.UPGRADE -> {
                Optional existingData = stack.getExistingData(MekanismAttachmentTypes.UPGRADES);
                if (existingData.isPresent()) {
                    UpgradeAware upgradeAware = (UpgradeAware)existingData.get();
                    Map<Upgrade, Integer> upgrades = upgradeAware.getUpgrades();
                    List<IInventorySlot> slots = upgradeAware.getInventorySlots(null);
                    if (!upgrades.isEmpty() || slots.stream().anyMatch(slot -> !slot.isEmpty())) {
                        yield new UpgradesRecipeData(upgrades, slots);
                    }
                }
                yield null;
            }
            case RecipeUpgradeType.QIO_DRIVE -> {
                DriveMetadata data = (DriveMetadata)stack.getData(MekanismAttachmentTypes.DRIVE_METADATA);
                if (data.count() > 0L && data.types() > 0) {
                    yield new QIORecipeData(data);
                }
                yield null;
            }
        };
    }

    @Nullable
    public static <TYPE extends RecipeUpgradeData<TYPE>> TYPE mergeUpgradeData(List<RecipeUpgradeData<?>> upgradeData) {
        if (upgradeData.isEmpty()) {
            return null;
        }
        RecipeUpgradeData<?> data = upgradeData.get(0);
        for (int i = 1; i < upgradeData.size(); ++i) {
            if ((data = data.merge(upgradeData.get(i))) != null) continue;
            return null;
        }
        return (TYPE)data;
    }
}

