/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.upgrade;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.component.UpgradeAware;
import mekanism.common.recipe.upgrade.ItemRecipeData;
import mekanism.common.recipe.upgrade.RecipeUpgradeData;
import mekanism.common.registries.MekanismAttachmentTypes;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class UpgradesRecipeData
implements RecipeUpgradeData<UpgradesRecipeData> {
    private final Map<Upgrade, Integer> upgrades;
    private final List<IInventorySlot> slots;

    UpgradesRecipeData(Map<Upgrade, Integer> upgrades, List<IInventorySlot> slots) {
        this.upgrades = upgrades;
        this.slots = slots;
    }

    @Override
    @Nullable
    public UpgradesRecipeData merge(UpgradesRecipeData other) {
        Map<Upgrade, Integer> upgrades;
        Map<Upgrade, Integer> smallerUpgrades = other.upgrades;
        Map<Upgrade, Integer> largerUpgrades = this.upgrades;
        if (largerUpgrades.size() < smallerUpgrades.size()) {
            smallerUpgrades = this.upgrades;
            largerUpgrades = other.upgrades;
        }
        if (smallerUpgrades.isEmpty()) {
            upgrades = largerUpgrades;
        } else {
            upgrades = new EnumMap<Upgrade, Integer>(largerUpgrades);
            for (Map.Entry<Upgrade, Integer> entry : smallerUpgrades.entrySet()) {
                Upgrade upgrade = entry.getKey();
                int total = upgrades.merge(upgrade, entry.getValue(), Integer::sum);
                if (total <= upgrade.getMax()) continue;
                return null;
            }
        }
        ArrayList<IInventorySlot> allSlots = new ArrayList<IInventorySlot>(this.slots);
        allSlots.addAll(other.slots);
        return new UpgradesRecipeData(upgrades, allSlots);
    }

    @Override
    public boolean applyToStack(ItemStack stack) {
        if (this.upgrades.isEmpty() && this.slots.stream().allMatch(IInventorySlot::isEmpty)) {
            return true;
        }
        UpgradeAware upgradeAware = (UpgradeAware)stack.getData(MekanismAttachmentTypes.UPGRADES);
        if (!upgradeAware.getSupportedUpgrades().containsAll(this.upgrades.keySet())) {
            return false;
        }
        upgradeAware.setUpgrades(this.upgrades);
        return ItemRecipeData.applyToStack(upgradeAware, this.slots);
    }
}

