/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import mekanism.api.MekanismAPI;
import mekanism.api.robit.RobitSkin;
import mekanism.common.registration.DeferredCodecHolder;
import mekanism.common.registration.DeferredCodecRegister;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class DatapackDeferredRegister<T>
extends DeferredCodecRegister<T> {
    private final ResourceKey<Registry<T>> datapackRegistryName;

    public static DatapackDeferredRegister<RobitSkin> robitSkins(String modid) {
        return new DatapackDeferredRegister<RobitSkin>(modid, MekanismAPI.ROBIT_SKIN_SERIALIZER_REGISTRY_NAME, MekanismAPI.ROBIT_SKIN_REGISTRY_NAME);
    }

    public static DatapackDeferredRegister<BiomeModifier> biomeModifiers(String modid) {
        return new DatapackDeferredRegister<BiomeModifier>(modid, NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, NeoForgeRegistries.Keys.BIOME_MODIFIERS);
    }

    public static DatapackDeferredRegister<StructureModifier> structureModifiers(String modid) {
        return new DatapackDeferredRegister<StructureModifier>(modid, NeoForgeRegistries.Keys.STRUCTURE_MODIFIER_SERIALIZERS, NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS);
    }

    public DatapackDeferredRegister(String modid, ResourceKey<? extends Registry<Codec<? extends T>>> serializerRegistryName, ResourceKey<Registry<T>> datapackRegistryName) {
        this(modid, serializerRegistryName, datapackRegistryName, DeferredCodecHolder::new);
    }

    public DatapackDeferredRegister(String modid, ResourceKey<? extends Registry<Codec<? extends T>>> serializerRegistryName, ResourceKey<Registry<T>> datapackRegistryName, Function<ResourceKey<Codec<? extends T>>, ? extends DeferredCodecHolder<T, ? extends T>> holderCreator) {
        super(serializerRegistryName, modid, holderCreator);
        this.datapackRegistryName = datapackRegistryName;
    }

    public void createAndRegisterDatapack(IEventBus bus, Codec<T> directCodec, @Nullable Codec<T> networkCodec) {
        this.register(bus);
        bus.addListener(event -> event.dataPackRegistry(this.datapackRegistryName, directCodec, networkCodec));
    }

    public ResourceKey<T> dataKey(String name) {
        return ResourceKey.create(this.datapackRegistryName, (ResourceLocation)new ResourceLocation(this.getNamespace(), name));
    }
}

