/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import com.mojang.serialization.DynamicOps;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import mekanism.api.IDisableableEnum;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.FloatingLongSupplier;
import mekanism.api.math.MathUtils;
import mekanism.common.attachments.FrequencyAware;
import mekanism.common.attachments.containers.AttachedContainers;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.MekanismDeferredRegister;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentComparator;
import net.neoforged.neoforge.attachment.IAttachmentCopyHandler;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public class AttachmentTypeDeferredRegister
extends MekanismDeferredRegister<AttachmentType<?>> {
    private static final IAttachmentSerializer<ByteTag, Boolean> TRUE_SERIALIZER = new IAttachmentSerializer<ByteTag, Boolean>(){

        @Nullable
        public ByteTag write(Boolean attachment) {
            return attachment != false ? ByteTag.ONE : null;
        }

        public Boolean read(IAttachmentHolder holder, ByteTag tag) {
            return tag.getAsByte() != 0;
        }
    };
    private static final IAttachmentSerializer<ByteTag, Boolean> FALSE_SERIALIZER = new IAttachmentSerializer<ByteTag, Boolean>(){

        @Nullable
        public ByteTag write(Boolean attachment) {
            return attachment != false ? null : ByteTag.ZERO;
        }

        public Boolean read(IAttachmentHolder holder, ByteTag tag) {
            return tag.getAsByte() != 0;
        }
    };
    private static final IAttachmentCopyHandler<Boolean> TRUE_COPIER = (holder, bool) -> bool != false ? Boolean.valueOf(true) : null;
    private static final IAttachmentCopyHandler<Boolean> FALSE_COPIER = (holder, bool) -> bool != false ? null : Boolean.valueOf(false);
    private static final IAttachmentCopyHandler<Integer> COPY_NON_ZERO_INT = (holder, i) -> i == 0 ? null : i;
    private static final IAttachmentCopyHandler<Long> COPY_NON_ZERO_LONG = (holder, l) -> l == 0L ? null : l;

    public AttachmentTypeDeferredRegister(String namespace) {
        super(NeoForgeRegistries.Keys.ATTACHMENT_TYPES, namespace);
    }

    public <CONTAINER extends INBTSerializable<CompoundTag>, ATTACHMENT extends AttachedContainers<CONTAINER>> MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ATTACHMENT>> registerContainer(String name, Supplier<ContainerType<CONTAINER, ATTACHMENT, ?>> typeSupplier) {
        return this.register(name, () -> {
            ContainerType containerType = (ContainerType)typeSupplier.get();
            return AttachmentType.serializable(containerType::getDefault).copyHandler((IAttachmentCopyHandler)containerType).comparator(AttachedContainers::isCompatible).build();
        });
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FrequencyAware<?>>> registerFrequencyAware(String name, Function<IAttachmentHolder, FrequencyAware<?>> defaultValueConstructor) {
        return this.register(name, () -> AttachmentType.serializable((Function)defaultValueConstructor).copyHandler((holder, attachment) -> attachment.copy(holder)).comparator(FrequencyAware::isCompatible).build());
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Boolean>> registerBoolean(String name, boolean defaultValue) {
        return this.register(name, () -> AttachmentType.builder(() -> defaultValue).serialize(defaultValue ? FALSE_SERIALIZER : TRUE_SERIALIZER).copyHandler(defaultValue ? FALSE_COPIER : TRUE_COPIER).comparator(Boolean::equals).build());
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Integer>> registerNonNegativeInt(String name, int defaultValue) {
        return this.registerInt(name, defaultValue, 0, Integer.MAX_VALUE);
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Integer>> registerInt(String name, final int defaultValue, final int min, final int max) {
        return this.register(name, () -> AttachmentType.builder(() -> defaultValue).serialize((IAttachmentSerializer)new IAttachmentSerializer<IntTag, Integer>(){

            @Nullable
            public IntTag write(Integer value) {
                if (value == defaultValue || value < min || value > max) {
                    return null;
                }
                return IntTag.valueOf((int)value);
            }

            public Integer read(IAttachmentHolder holder, IntTag tag) {
                return Mth.clamp((int)tag.getAsInt(), (int)min, (int)max);
            }
        }).copyHandler(defaultValue == 0 ? COPY_NON_ZERO_INT : (holder, attachment) -> attachment == defaultValue ? null : attachment).comparator(Integer::equals).build());
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Long>> registerNonNegativeLong(String name, long defaultValue) {
        return this.registerLong(name, defaultValue, 0L, Long.MAX_VALUE);
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Long>> registerLong(String name, final long defaultValue, final long min, final long max) {
        return this.register(name, () -> AttachmentType.builder(() -> defaultValue).serialize((IAttachmentSerializer)new IAttachmentSerializer<LongTag, Long>(){

            @Nullable
            public LongTag write(Long value) {
                if (value == defaultValue || value < min || value > max) {
                    return null;
                }
                return LongTag.valueOf((long)value);
            }

            public Long read(IAttachmentHolder holder, LongTag tag) {
                return Mth.clamp((long)tag.getAsLong(), (long)min, (long)max);
            }
        }).copyHandler(defaultValue == 0L ? COPY_NON_ZERO_LONG : (holder, attachment) -> attachment == defaultValue ? null : attachment).comparator(Long::equals).build());
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<FloatingLong>> registerFloatingLong(String name, final FloatingLongSupplier defaultValue) {
        return this.register(name, () -> AttachmentType.builder((Supplier)defaultValue).serialize((IAttachmentSerializer)new IAttachmentSerializer<StringTag, FloatingLong>(){

            @Nullable
            public StringTag write(FloatingLong value) {
                if (value.equals(defaultValue.get())) {
                    return null;
                }
                return StringTag.valueOf((String)value.toString());
            }

            public FloatingLong read(IAttachmentHolder holder, StringTag tag) {
                return FloatingLong.parseFloatingLong(tag.getAsString());
            }
        }).copyHandler((holder, attachment) -> attachment.equals(defaultValue.get()) ? null : attachment.copyAsConst()).comparator(Objects::equals).build());
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<UUID>> registerUUID(String name) {
        return this.register(name, () -> AttachmentType.builder(() -> Util.NIL_UUID).serialize((IAttachmentSerializer)new IAttachmentSerializer<IntArrayTag, UUID>(){

            @Nullable
            public IntArrayTag write(UUID value) {
                return value.equals(Util.NIL_UUID) ? null : NbtUtils.createUUID((UUID)value);
            }

            public UUID read(IAttachmentHolder holder, IntArrayTag tag) {
                return NbtUtils.loadUUID((Tag)tag);
            }
        }).copyHandler((holder, uuid) -> uuid.equals(Util.NIL_UUID) ? null : uuid).comparator(UUID::equals).build());
    }

    @Override
    public <ENUM extends Enum<ENUM>> MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ENUM>> register(String name, Class<ENUM> clazz) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        final Enum defaultValue = values[0];
        final IntFunction<Enum> reader = clazz.isAssignableFrom(IDisableableEnum.class) ? index -> {
            Enum value = MathUtils.getByIndexMod(values, index);
            return ((IDisableableEnum)((Object)value)).isEnabled() ? value : defaultValue;
        } : index -> MathUtils.getByIndexMod(values, index);
        return this.register(name, () -> AttachmentType.builder(() -> defaultValue).serialize(new IAttachmentSerializer<IntTag, ENUM>(){

            @Nullable
            public IntTag write(ENUM value) {
                if (value == defaultValue) {
                    return null;
                }
                return IntTag.valueOf((int)((Enum)value).ordinal());
            }

            public ENUM read(IAttachmentHolder holder, IntTag tag) {
                return (Enum)reader.apply(tag.getAsInt());
            }
        }).copyHandler((holder, attachment) -> attachment == defaultValue ? null : attachment).comparator((a, b) -> a == b).build());
    }

    public <ENUM extends Enum<ENUM>> MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Optional<ENUM>>> registerOptional(String name, Class<ENUM> clazz) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        final IntFunction<Optional> reader = clazz.isAssignableFrom(IDisableableEnum.class) ? index -> Optional.of(MathUtils.getByIndexMod(values, index)).filter(value -> ((IDisableableEnum)((Object)value)).isEnabled()) : index -> Optional.of(MathUtils.getByIndexMod(values, index));
        return this.register(name, () -> AttachmentType.builder(Optional::empty).serialize(new IAttachmentSerializer<IntTag, Optional<ENUM>>(){

            @Nullable
            public IntTag write(Optional<ENUM> value) {
                return value.map(val -> IntTag.valueOf((int)val.ordinal())).orElse(null);
            }

            public Optional<ENUM> read(IAttachmentHolder holder, IntTag tag) {
                return (Optional)reader.apply(tag.getAsInt());
            }
        }).copyHandler(AttachmentTypeDeferredRegister.optionalCopier((holder, attachment) -> attachment)).comparator(AttachmentTypeDeferredRegister.optionalComparator((a, b) -> a == b)).build());
    }

    public MekanismDeferredHolder<AttachmentType<?>, AttachmentType<Component>> registerComponent(String name, final Supplier<Component> defaultValueSupplier) {
        return this.register(name, () -> AttachmentType.builder((Supplier)defaultValueSupplier).serialize((IAttachmentSerializer)new IAttachmentSerializer<Tag, Component>(){

            @Nullable
            public Tag write(Component value) {
                if (value.equals(defaultValueSupplier.get())) {
                    return null;
                }
                return ComponentSerialization.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)value).result().orElse(null);
            }

            public Component read(IAttachmentHolder holder, Tag tag) {
                return (Component)ComponentSerialization.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).result().orElseGet(defaultValueSupplier);
            }
        }).copyHandler((holder, attachment) -> attachment.copy()).comparator(Object::equals).build());
    }

    public <TYPE> MekanismDeferredHolder<AttachmentType<?>, AttachmentType<ResourceKey<TYPE>>> registerResourceKey(String name, final ResourceKey<? extends Registry<TYPE>> registryKey, final Supplier<ResourceKey<TYPE>> defaultValueSupplier) {
        return this.register(name, () -> AttachmentType.builder((Supplier)defaultValueSupplier).serialize(new IAttachmentSerializer<StringTag, ResourceKey<TYPE>>(){

            @Nullable
            public StringTag write(ResourceKey<TYPE> value) {
                if (value == defaultValueSupplier.get()) {
                    return null;
                }
                return StringTag.valueOf((String)value.location().toString());
            }

            public ResourceKey<TYPE> read(IAttachmentHolder holder, StringTag tag) {
                ResourceLocation rl = ResourceLocation.tryParse((String)tag.getAsString());
                return rl == null ? (ResourceKey)defaultValueSupplier.get() : ResourceKey.create((ResourceKey)registryKey, (ResourceLocation)rl);
            }
        }).copyHandler((arg_0, arg_1) -> AttachmentTypeDeferredRegister.lambda$registerResourceKey$30((Supplier)defaultValueSupplier, arg_0, arg_1)).comparator((a, b) -> a == b).build());
    }

    public static <TYPE> IAttachmentCopyHandler<Optional<TYPE>> optionalCopier(IAttachmentCopyHandler<TYPE> innerCopier) {
        return (attachmentHolder, optional) -> {
            Object copy;
            if (optional.isPresent() && (copy = innerCopier.copy(attachmentHolder, optional.get())) != null) {
                return Optional.of(copy);
            }
            return null;
        };
    }

    public static <TYPE> IAttachmentComparator<Optional<TYPE>> optionalComparator(IAttachmentComparator<TYPE> innerComparator) {
        return (a, b) -> {
            if (a.isPresent()) {
                if (b.isPresent()) {
                    return innerComparator.areCompatible(a.get(), b.get());
                }
                return false;
            }
            return b.isEmpty();
        };
    }

    private static /* synthetic */ ResourceKey lambda$registerResourceKey$30(Supplier defaultValueSupplier, IAttachmentHolder holder, ResourceKey attachment) {
        return attachment == defaultValueSupplier.get() ? null : attachment;
    }
}

