/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import mekanism.api.providers.IItemProvider;
import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.common.block.BlockBounding;
import mekanism.common.registration.MekanismDeferredHolder;
import mekanism.common.registration.MekanismDeferredRegister;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.FluidDeferredRegister;
import mekanism.common.registration.impl.ItemDeferredRegister;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.NotNull;

public class CreativeTabDeferredRegister
extends MekanismDeferredRegister<CreativeModeTab> {
    private final Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs;

    public CreativeTabDeferredRegister(String modid) {
        this(modid, (BuildCreativeModeTabContentsEvent event) -> {});
    }

    public CreativeTabDeferredRegister(String modid, Consumer<BuildCreativeModeTabContentsEvent> addToExistingTabs) {
        super(Registries.CREATIVE_MODE_TAB, modid);
        this.addToExistingTabs = addToExistingTabs;
    }

    public void register(@NotNull IEventBus bus) {
        super.register(bus);
        bus.addListener(this.addToExistingTabs);
    }

    public MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> registerMain(ILangEntry title, IItemProvider icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(this.getNamespace(), title, icon, operator);
    }

    public MekanismDeferredHolder<CreativeModeTab, CreativeModeTab> register(String name, ILangEntry title, IItemProvider icon, UnaryOperator<CreativeModeTab.Builder> operator) {
        return this.register(name, () -> {
            CreativeModeTab.Builder builder = CreativeModeTab.builder().title((Component)title.translate()).icon(icon::getItemStack).withTabFactory(MekanismCreativeTab::new);
            return ((CreativeModeTab.Builder)operator.apply(builder)).build();
        });
    }

    public static void addToDisplay(CreativeModeTab.Output output, ItemLike ... items) {
        for (ItemLike item : items) {
            CreativeTabDeferredRegister.addToDisplay(output, item);
        }
    }

    public static void addToDisplay(CreativeModeTab.Output output, ItemLike itemLike) {
        Item item = itemLike.asItem();
        if (item instanceof ICustomCreativeTabContents) {
            ICustomCreativeTabContents contents = (ICustomCreativeTabContents)item;
            if (contents.addDefault()) {
                output.accept(itemLike);
            }
            contents.addItems(output);
        } else {
            output.accept(itemLike);
        }
    }

    public static void addToDisplay(ItemDeferredRegister register, CreativeModeTab.Output output) {
        for (Holder itemProvider : register.getEntries()) {
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)itemProvider.value());
        }
    }

    public static void addToDisplay(BlockDeferredRegister register, CreativeModeTab.Output output) {
        for (Holder holder : register.getPrimaryEntries()) {
            Block block = (Block)holder.value();
            if (block instanceof BlockBounding) continue;
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)block);
        }
    }

    public static void addToDisplay(FluidDeferredRegister register, CreativeModeTab.Output output) {
        for (Holder holder : register.getBucketEntries()) {
            CreativeTabDeferredRegister.addToDisplay(output, (ItemLike)holder.value());
        }
    }

    public static interface ICustomCreativeTabContents {
        public void addItems(CreativeModeTab.Output var1);

        default public boolean addDefault() {
            return true;
        }
    }

    public static class MekanismCreativeTab
    extends CreativeModeTab {
        protected MekanismCreativeTab(CreativeModeTab.Builder builder) {
            super(builder);
        }

        public int getLabelColor() {
            return SpecialColors.TEXT_TITLE.argb();
        }
    }
}

